//var wsUri = "ws://"+location.hostname+":9015";
var wsUriDirector = "ws://"+location.hostname+":8964";
var AiDirector_websocket = null;
var gDeviceIndex   = 0;
var gTableRowIndex = 0;
var gCameraConnCnt = 0;
var gPTZTimerId = 0;
var gNurevaPort = 8931;
var gSelectMicChannelChange = 0;
var gWhileBlockWaitResponse_flag = 0;
var shouldStopExecution = false;
var gVideoOutputStatus = 0;
let gEditScriptID = -1;

//----------------WebSocket-------------------
let workspace;
let currentMaxPriority = 0;
//----------------Workspace.System.Function-------------------
let selectedButtonsIndexes = [];
let selectedButtonIds = [];
let selectedIds = [];
let currentlySelectedButtonId = null;
let selectedButtonId = null;
let shouldStop = false;
let currentModeIndex = 0;
let orderedSelectedIds = selectedIds.slice();
let lastModeIndexChangeName = 0;
let draggedIndex = null;
let gExecutionStatus = false;  
let gRunCodeStatus = false;
let gRunCodeInScriptStatus = false;
let gExecutionLogIsChecked = false;
let gScriptLogIsChecked = false;
let gNowGetProfileResponseCount = 0;
let gNowGetProfileIndex = 0;
let gProfileResponseCountEnd = 5;
let gProfileData = {};
let gDotsIntervalMessageTimer;
let gNowWaitResponseSetProfile = {};
var getAIDirectorBlockUIPage = false;
let gUpdateXMLProfile = false;
var getSoundAllSetForAIDirector = false;
let gNowGetMicrophoneSettingResponseCount = 0;
var getAIDirectorConfigDataInit = false;

//----------------WebSocket-------------------
class EventEmitter {

    constructor() {
        this.events = {};
    }

    on(event, listener) {
        if (!this.events[event]) {
            this.events[event] = [];
        }
        this.events[event].push(listener);
    }

    emit(event, data) {
        if (this.events[event]) {
            this.events[event].forEach(listener => listener(data));
        }
    }
}

const eventEmitter = new EventEmitter();

function openAIDirector() {
    $("#DivMainPage").load("./page/ai_blockly.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;


        if (cameraSettings.ModelName == "CV420e") {
            $(".tabPageDiv").removeClass("tabPageDiv");
            $(".mic-tabNavDiv").hide();
            $(".tabs-content").removeClass("tabs-content").removeClass("content_H702");
            $("#Div_StreamType").removeClass("tabs-panel").removeClass("panel_H702");
        } 

        let Profile = document.getElementById('Select_Profile');
        let ProfileIndex = parseInt(Profile.value,10);
        
        let profileCheckTimer = setTimeout(function () {
            if(Profile.length !== 0 && ProfileIndex != 0)
            {
                clearTimeout(profileCheckTimer);
                if(document.getElementById("Label_Intelligence_Director"))
                {
                    initBlockly();
                    AiDirector_initWebSocket();
                    AiDirector_initEasyMode();
                }
            }
            else
            {
                sendMessageIndex("GetAllProfile");
                sendMessageIndex("GetCurrentProfileID");
            }
        }, 300);  
        document.getElementById("Select_Profile").style.display = "block";
        document.getElementById("Label_Profile").style.display = "block";      
    });
}
let gPageIsInAIDirector = false;
function AiDirector_initWebSocket() {
    // AiDirector_websocket = new WebSocket( wsUri );
    AiDirector_websocket = new WebSocket( wsUriDirector );
    
    AiDirector_websocket.addEventListener('open', function() {
        
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();

        console.log('open connection');
        gPageIsInAIDirector = true;
        let DirectorNormalMode_edit = document.getElementById('DirectorNormalMode-editChanges');
        let DirectorNormalMode_log = document.getElementById('Easymode_execution_msg_btn');
        let DirectorNormalMode_run = document.getElementById('DirectorNormalMode-codestaus');
        let DirectorEnable = document.getElementById('Label_SetEnableDirector');
        let DirectorEnableSwitchonoff = document.getElementById('SetEnableDirectorSwitchonoff');
        let DirectorEnableContainer = document.getElementById('btnEnableDirectorContainer');

        if(DirectorNormalMode_run)
            DirectorNormalMode_run.style.display  = 'none';
        if(DirectorNormalMode_edit)
            DirectorNormalMode_edit.style.display = 'none';
        if(DirectorNormalMode_log)
            DirectorNormalMode_log.style.display  = 'none';
        if(DirectorEnable)
            DirectorEnable.style.display  = 'none';
        if(DirectorEnableSwitchonoff)
            DirectorEnableSwitchonoff.style.display  = 'none';
        if(DirectorEnableContainer)
            DirectorEnableContainer.style.display  = 'none';

        sendMessageIndex("GetCurrentProfileID");
        AiDirector_sendMessage("GetSystemSettingForDirector");
        AiDirector_sendMessage("GetVideoOutputSettingForDirector");
        AiDirector_sendMessage("GetSoundNumbersForDirector");
        AiDirector_sendMessage("GetCameraListForDirector");


        let Programming_Workspace = document.getElementById('Programming_Workspace_Div');
        if(Programming_Workspace)
            Programming_Workspace.style.display = 'none';
        
        if(gUpdateXMLProfile)
        {
            let DirectorNormalMode_edit = document.getElementById('DirectorNormalMode-editChanges');
            let DirectorNormalMode_log = document.getElementById('Easymode_execution_msg_btn');
            let DirectorNormalMode_run = document.getElementById('DirectorNormalMode-codestaus');
            let DirectorEnable = document.getElementById('Label_SetEnableDirector');
            let DirectorEnableSwitchonoff = document.getElementById('SetEnableDirectorSwitchonoff');
            let DirectorEnableContainer = document.getElementById('btnEnableDirectorContainer');
            if(DirectorNormalMode_run)
                DirectorNormalMode_run.style.display  = 'block';
            if(DirectorNormalMode_edit)
                DirectorNormalMode_edit.style.display = 'block';
            if(DirectorNormalMode_log)
                DirectorNormalMode_log.style.display  = 'block';
            if(DirectorEnable)
                DirectorEnable.style.display  = 'block';
            if(DirectorEnableSwitchonoff)
                DirectorEnableSwitchonoff.style.display  = 'block';
            if(DirectorEnableContainer)
                DirectorEnableContainer.style.display  = 'block';
        }
        let Profile = document.getElementById('Select_Profile');
        if(Profile.length !== 0)
        {
            if(!gUpdateXMLProfile)
            {
                setTimeout(function() {
                    AiDirector_sendMessage("GetAIDirectorProfileDataForDirector", {
                        Command: "GetAIDirectorProfileDataForDirector",
                        ProfileIndex: parseInt(Profile.value,10),
                        ConfigFileIndex: 0,
                    });
                }, 100);
                
                gGetProfileTempData = true;
                getAIDirectorBlockUIPage = true;
                gNowGetProfileResponseCount = 0;
                gProfileResponseCountEnd = btnTexts.length;

                blockUIforPage();
            }

        }
        else
        {
            sendMessageIndex("GetAllProfile");
            sendMessageIndex("GetCurrentProfileID");
            let Programming_Workspace = document.getElementById('Programming_Workspace_Div');
            Programming_Workspace.style.display = 'none';
        }
    });

    AiDirector_websocket.addEventListener('error',function(evt){
        //console.log('connection fail');
        //alert("connection fail");
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    AiDirector_websocket.addEventListener('message',function(evt){   
        if (evt.data instanceof Blob) 
        {
            const imgLoader = document.getElementById('AIDirectordmsloader');
            if(imgLoader)
                AIDirectorcreateImageFromFile(imgLoader, evt.data);
        } 
        else 
        {
            try {
                AiDirector_receivedDataMicrophone(evt.data);
            } catch (e) {
                //console.error('Error parsing JSON:', e);
            }
        }
    });

    AiDirector_websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };
}

function AIDirectorcreateImageFromFile(imgElement, fileBlob) {
    return new Promise((resolve, reject) => {
        const objectURL = URL.createObjectURL(fileBlob);
        imgElement.onload = () => {
            URL.revokeObjectURL(objectURL);
            resolve(imgElement);
        };
        imgElement.src = objectURL;
    });
}

function AiDirector_receivedDataMicrophone(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);
    
    //console.log('obj.Reply:',obj.Reply,obj);

    switch (obj.Reply) {

        case "GetResponsMessage":
            AiDirector_updateResponsMessage(obj);
        break;
        case "GetScriptStatus":
            AiDirector_updateScriptStatus(obj);
        break;
        case "GetSoundNumbersForDirector": //reply search camera result
            AiDirector_updateSoundNumbers(obj);
        break;

        case "GetSoundSettingForDirector": //reply sound setting
            AiDirector_updateSoundSetting(obj);
        break;

        case "GetSoundAdvanceSettingForDirector": //reply sound advance setting
            AiDirector_updateAdvanceSetting(obj);
        break;

        case "GetSoundCamMapForDirector": //reply sound camera mapping
            AiDirector_updateCameraMapping(obj);
        break;

        case "SoundConnect":
            AiDirector_updateSoundDeviceConnect(obj);
        break;

        case "GetCamAISetting":
            //updateCamAISetting(obj);
        break;

        case "CameraConnect":
            //console.log('CameraConnect Reply!!');
            AiDirector_updateCamConnect(obj);
        break;

        case "GetVideoResolution":
            AiDirector_updateVideoResolution(obj);
        break;

        case "GetVideoFps":
            AiDirector_updateVideoFps(obj);
        break;

        case "GetSoundPos":
            //console.log('GetSoundPos!!');
            AiDirector_updateGetSoundPos(obj);
        break;

        case "GetSoundSourceData":
            //console.log('GetSoundSourceData!!');
            //updateGetSoundSourceData(obj);
        break;

        case "GetVoiceTracking":
            AiDirector_updateGetVoiceTracking(obj);
        break;

        case "GetSoundDevicePort":
            AiDirector_updateSoundDevicePort(obj);
        break;

        case "GetVideoOutputSettingForDirector": //reply Video Output Setting result
            AiDirector_updatedVideoOutputStatus(obj);
        break;

        case "GetFocusMode":
            AiDirector_updatedPTZFocusMode(obj);
        break;

        case "GetMirrorFlipType":
            //AiDirector_updatedMirrorFlipType(obj);
        break;

        case "GetPanFlip":
            AiDirector_updatedPanFlip(obj);
        break;
        
        case "SetSoundMXCWSeatName":
            //AiDirector_updatedShureMXCWSeatName(obj);
        break;

        case "GetStandByStatus":
            AiDirector_updatedGetStandByStatus(obj);
        break;

        case"StartVideoStreaming":
            gVideoOutputStatus = true;
            updatedStartVideoStreaming(obj,false);
        break;

        case"StopVideoStreaming":
            gVideoOutputStatus = false;
            updatedStopVideoStreaming(obj);
        break;

        case "GetCurrentProfileID":
            updatedGetCurrentProfile(obj);
        break;

        case "GetAIDirectorProfileDataForDirector":
            AiDirector_updatedGetAIDirectorProfileData(obj);
        break;

        case "SetAIDirectorProfileDataForDirector":
            AiDirector_updatedSetAIDirectorProfileData(obj);
        break;

        case "GetCommandIsEmpty":
            AiDirector_updateGetCommandIsEmpty(obj);
        break;

        case "GetSystemSettingForDirector":
            AiDirector_updateGetSystemSetting(obj);
        break;

        case "GetCameraListForDirector":
            AiDirector_updateGetCameraList(obj);
        break;

        case "CheckDirectorRun":
            Director_handleCheckDirectorRun(obj)
            break;

    }

}

var gSoundDeviceConnectStatus = {};
var gsoundPosStatus = {};

var AIBoxState = {
    Video: {
        Streaming: false,
        OutputLayout: 0,
        OutputFormat: 0,
        Crop: false,
        Pos1: "Off",
        Pos2: "Off",
        Pos3: "Off",
        Pos4: "Off",
    },
    Sound: {
        SoundNumbers: 1,
    },
    Tab: []
};

let gGetCommandIsEmpty = false;
function AiDirector_updateGetCommandIsEmpty(msg) {
    let button = document.getElementById('script-run-button');
    let NormalModebutton = document.getElementById('DirectorNormalMode-codestaus');
    let EditModebutton = document.getElementById('DirectorNormalMode-editChanges');

    addMessage('Script End!');
    UnblockUIforPage();
    gGetCommandIsEmpty = true;

    if(gRunCodeInScriptStatus)
    {
    	gRunCodeInScriptStatus = false;
    	button.textContent = window.LanguageManager.getTranslatedText("Run");
        EditModebutton.disabled = false;

        if ($(".Director_Btn").hasClass('active')) 
        {
            $(".Director_Btn").removeClass('active').addClass('inactive');
        }
    }
    
    if(gExecutionStatus)
    {
        gExecutionStatus = false;
        NormalModebutton.textContent = window.LanguageManager.getTranslatedText("Run");
        gRunCodeStatus = true;

        if ($(".Director_Btn").hasClass('active')) 
        {
            $(".Director_Btn").removeClass('active').addClass('inactive');
        }
        
        const getAllWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
        let getcurrentOrderIds = Array.from(getAllWrappers).map(wrapper => wrapper.getAttribute('data-id'));
        let getorderedSelectedIds = getcurrentOrderIds.filter(id => selectedIds.includes(id));
        let getorderedNotSelectedIds = getcurrentOrderIds.filter(id => !selectedIds.includes(id));
        
        for (const id of getorderedNotSelectedIds) 
        {
            const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
            const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');

            otherWrapper.classList.remove("fade-color");
            otherWrapper.classList.remove("active-hover-effect");
            modeText.classList.remove('show-modeText');
        }
        
        for (const id of getorderedSelectedIds) 
        {
            const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
            const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
            otherWrapper.classList.remove("fade-color");
            otherWrapper.classList.remove("active-hover-effect");
            modeText.classList.remove('show-modeText');
        }
    }
}

function Director_handleCheckDirectorRun(obj)
{
    if(obj.DirectorRunStatus !== undefined)
    {
        gCheckDirectorRun = obj.DirectorRunStatus;

        if(gCheckDirectorRun)
        {
            if ($(".Director_Btn").hasClass('inactive')) 
            {
                $(".Director_Btn").removeClass('inactive').addClass('active');
                sendCheckDirectorRunCommand();
            }
        }
        else
        {
            clearInterval(gDirectorCheckInterval);

            if ($(".Director_Btn").hasClass('active')) 
            {
                $(".Director_Btn").removeClass('active').addClass('inactive');
            }
        }
    }
}

function AiDirector_updateGetSystemSetting(obj) 
{

    if (obj.System && typeof obj.System.EnableAIDirector !== 'undefined') 
    {
        const enableAIDirector = obj.System.EnableAIDirector;        
        const mockEvent = {
            checked: enableAIDirector
        };

        setTimeout(function(){
            SettingEnableDirectorModeChange(mockEvent);
        },100);

    }


    let AIDirectorMode = parseInt(obj.System.AutoConnection.AIDirectorMode,10)+1;

    if(AIDirectorMode >= 0)
    {
        let AIDirectorModeButton = document.getElementById('DirectorNormalMode-button'+AIDirectorMode);
        if(AIDirectorModeButton)
        {
            AIDirectorModeButton.click(); 
        }
    }
}

function AiDirector_updatedVideoOutputStatus(msg) {
    AIBoxState.Video.Streaming = msg.IsStartStreaming;

    AIBoxState.Video.OutputLayout = msg.OutputLayout;
    AIBoxState.Video.OutputFormat = msg.OutputFormat;
    AIBoxState.Video.Crop = msg.IsCrop;
    if(msg.SourcePositionArray[0])
        AIBoxState.Video.Pos1 = msg.SourcePositionArray[0].Camera !== "Off" ? msg.SourcePositionArray[0].Camera : "Off";
    if(msg.SourcePositionArray[1])
        AIBoxState.Video.Pos2 = msg.SourcePositionArray[1].Camera !== "Off" ? msg.SourcePositionArray[1].Camera : "Off";
    if(msg.SourcePositionArray[2])
        AIBoxState.Video.Pos3 = msg.SourcePositionArray[2].Camera !== "Off" ? msg.SourcePositionArray[2].Camera : "Off";
    if(msg.SourcePositionArray[3])
        AIBoxState.Video.Pos4 = msg.SourcePositionArray[3].Camera !== "Off" ? msg.SourcePositionArray[3].Camera : "Off";
    //getVideoOutputStatusA(msg);

    if (msg.IsStartStreaming == true) {
        // UnblockUIforPage();
        gVideoOutputStatus=true;
    }
    else {
        gVideoOutputStatus=false;
    }
    updateVideoOnOffButton(gVideoOutputStatus);
}



function AiDirector_updateScriptStatus(obj)
{
    if(obj.Status == "Stop")
    {
        let ScriptString = 'Script stop!';
        getAIDirectorConfigDataInit = false;
        addMessage(ScriptString);
        UnblockUIforPage();
    }
    else if(obj.Status == "Start")
    {
        let ScriptString = 'Script start run!';
        getAIDirectorConfigDataInit = false;
        addMessage(ScriptString);
        UnblockUIforPage();
    }
    else if(obj.Status == "End")
    {
        let ScriptString = 'Configuration initialization in progress...';
        getAIDirectorConfigDataInit = true;
        addMessage(ScriptString);
        blockUIforPage();
    }
}

function AiDirector_updateResponsMessage(obj)
{
    gExecutionStatus = true;
    gRunCodeStatus = true;

    if(!obj.isScriptRunning)
    {
        $(".Director_Btn").removeClass('active').addClass('inactive');
    }

    if(obj.Command == "sendDelayTimecmd")
    {
        let DelaySetupTime = obj.DelaySetupTime;
        let ScriptString = 'Set Delay time : '+DelaySetupTime+'ms';
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendCameraPresetCmd")
    {
        let CameraShow = obj.CameraShow;
        let Preset = parseInt(obj.Preset,10);
        let ScriptString = 'Set Camera : '+CameraShow+' Preset : '+Preset;
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendCameraHomeCmd")
    {
        let CameraShow = obj.CameraShow;
        let ScriptString = 'Set Camera : '+CameraShow+' Back Home';
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendCameraPresetSpeedCmd")
    {
        let CameraShow = obj.CameraShow;
        let PresetSpeedShow = obj.PresetSpeedShow;
        let ScriptString = 'Set Camera : '+CameraShow+' Preset Speed : '+PresetSpeedShow+' deg/sec';
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendCameraHEXCmd")
    {
        let CameraShow = obj.CameraShow;
        let HexCommand = obj.HexCommand;
        let ScriptString = 'Set Camera : '+CameraShow+' Hex Command : '+HexCommand;
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "GetScriptStatus")
    {
        if(obj.Status == "Stop")
        {
            let ScriptString = 'Script stop!';
            getAIDirectorConfigDataInit = false;
            addMessage(ScriptString);
            UnblockUIforPage();
            gExecutionStatus = false;
            gRunCodeStatus = false;
            if ($(".Director_Btn").hasClass('active')) 
            {
                $(".Director_Btn").removeClass('active').addClass('inactive');
            }
        }
        else if(obj.Status == "Start")
        {
            let ScriptString = 'Script start run!';
            getAIDirectorConfigDataInit = false;
            addMessage(ScriptString);
            UnblockUIforPage();
            if ($(".Director_Btn").hasClass('inactive')) 
            {
                $(".Director_Btn").removeClass('inactive').addClass('active');
            }
        }
        else if(obj.Status == "End")
        {
            let ScriptString = 'Configuration initialization in progress...';
            getAIDirectorConfigDataInit = true;
            addMessage(ScriptString);
            blockUIforPage();
            gExecutionStatus = false;
            gRunCodeStatus = false;
            if ($(".Director_Btn").hasClass('active')) 
            {
                $(".Director_Btn").removeClass('active').addClass('inactive');
            }
        }
    }
    if(obj.Command == "repeatLoop")
    {
        let ScriptString = 'Set loop Exection';
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendAfterReschedule")
    {
        let delay = parseFloat(obj.Delay,10);
        let ScriptString = 'Set Reschedule After : '+delay.toFixed(1)+'s';
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "repeatCount")
    {
        let count = obj.Count;
        let ScriptString = 'Set repeat : '+count;
        addMessage(ScriptString);
        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
    }
    if(obj.Command == "sendVideoSourcePosition")
    {
        let cameraInfo = obj.CameraInfo;        
        let ScriptString = '';
        Object.keys(cameraInfo).forEach((key, index) => {
            let ip = cameraInfo[key].ip;
            if(parseInt(ip,10) != 0){
                ScriptString = `Set Video Source Position: Camera ${index + 1}: ${ip}.`;
                addMessage(ScriptString);
            }
        });
    }
    if(obj.Command == "sendSetSeamlessSwitching")
    {
        let videoLayoutMode = parseInt(obj.VideoLayoutMode,10);
        let ScriptString = '';
        if (videoLayoutMode == 0) 
        {
            ScriptString = `Set Seamless Switching.`;
        }
        else
        {
            ScriptString = `Set No Switching.`;
        }
        addMessage(ScriptString);
    }
    if(obj.Command == "sendVideoSourceLayout")
    {
        let videoLayoutMode = parseInt(obj.VideoLayoutMode,10);
        let cameraInfo = obj.CameraInfo;
        let cameraCount = Object.keys(cameraInfo).length;
        let ScriptString = '';
        if (videoLayoutMode == 0) 
        {
            switch (cameraCount) 
            {
                case 1:
                    ScriptString = `Set Video Source Layout for Cross: 1x1.`;
                    break;
                case 2:
                    ScriptString = `Set Video Source Layout for Cross: 1x2.`;
                    break;
                case 3:
                    ScriptString = `Set Video Source Layout for Cross: 1x3.`;
                    break;
                case 4:
                    ScriptString = `Set Video Source Layout for Cross: 2x2.`;
                    break;
            }
        } 
        else 
        {
            switch (cameraCount) 
            {
                case 1:
                    ScriptString = `Set Video Source Layout for PBP: 1x1.`;
                    break;
                case 2:
                    ScriptString = `Set Video Source Layout for PBP: 1x2.`;
                    break;
                case 3:
                    ScriptString = `Set Video Source Layout for PBP: 1x3.`;
                    break;
                case 4:
                    ScriptString = `Set Video Source Layout for PBP: 1x4.`;
                    break;
            }
        }
        addMessage(ScriptString);

        Object.keys(cameraInfo).forEach((key, index) => {
            let ip = cameraInfo[key].ip;
            if(parseInt(ip,10) != 0){
                ScriptString = `Set Video Source Position: Camera ${index + 1}: ${ip}.`;
                addMessage(ScriptString);
            }
        });    
    }
    if (obj.Command == "snedTriggerConditions") {
        let micProps = obj.MicProps;
        if(micProps !== "status")
        {
            let ScriptString ='Set Convetsation Mode : ';
            addMessage(ScriptString);
        
            ScriptString = "Mic : ";
            if (micProps.mic == 99){
                ScriptString += `Mic Selected : Null , `;
            }
            else{
                let mic1Value = micProps.mic;
                let matchedMicrophone = gMicrophoneSelectOptionNew.find(option => {
                    if(option[1] == mic1Value.toString())
                    {
                        return option[0];
                    }
                });
                ScriptString += 'Mic Selected : '+matchedMicrophone[0]+', ';
            }
            ScriptString += `Time Trigger : ${micProps.timeTrigger}, Mute Time : ${micProps.timeMute}, Trigger Count : ${micProps.triggerCount}\n`;
            addMessage(ScriptString);
        }
        else
        {
            let Status = obj.Status;
            let ScriptString = '';
            if(Status == "triggerAllOff")
            {
                ScriptString ='Mic. All trigger off';
                addMessage(ScriptString);
            }
            if(Status == "triggerOne")
            {
                let Pos = obj.Pos;
                ScriptString ='Mic. Pos '+(parseInt(Pos,10)+1)+' trigger';
                addMessage(ScriptString);
            }
            if(Status == "triggerTwo")
            {
                let Pos1 = obj.Pos1;
                let Pos2 = obj.Pos2;
                ScriptString ='Mic. Pos '+(parseInt(Pos1,10)+1)+' and Pos '+(parseInt(Pos2,10)+1)+' trigger';
                addMessage(ScriptString);
            }
        }
    }
    if(obj.Command == "GetDelayTime")
    {
        if(obj.Status == "Running")
        {
            let delaytype = parseInt(obj.DelayType,10);
            let delayshow;
            let timeString;

            if(delaytype == 0)
            {
                delayshow ='ms';
                timeString = 'DelayTime : '+parseInt(obj.DelayTime,10)+delayshow;
            }
            else if(delaytype == 1)
            {
                delayshow ='s';
                timeString = 'DelayTime : '+parseInt(obj.DelayTime,10)/1000+delayshow;
            }
            else if(delaytype == 2)
            {
                delayshow ='s';
                timeString = 'DelayTime : '+parseInt(obj.DelayTime,10)/1000+delayshow;
            }
            addMessage(timeString);
        }
        else if(obj.Status == "Scuessed")
        {
            let delaytype = parseInt(obj.DelayType,10);
            let delayshow;
            let timeString;
        
            if(delaytype == 0)
            {
                delayshow ='ms';
                timeString = 'Run DelayTime : '+parseInt(obj.DelayTime,10)+delayshow+' end!';
            }
            else if(delaytype == 1)
            {
                delayshow ='s';
                timeString = 'Run DelayTime : '+parseInt(obj.DelayTime,10)/1000+delayshow+' end!';
            }
            else if(delaytype == 2)
            {
                delayshow ='min';
                timeString = 'Run DelayTime : '+parseInt(obj.DelayTime,10)/60000+delayshow+' end!';
            }
            addMessage(timeString);
        }

        if ($(".Director_Btn").hasClass('inactive'))
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }  
    }
    if(obj.Command == "sendScriptStatusCmd")
    {
        let status = obj.isScriptRunning;
        if(status)
        {
            let button = document.getElementById('DirectorNormalMode-codestaus');
            let editbutton = document.getElementById('DirectorNormalMode-editChanges');
            if(!gGetCommandIsEmpty)
                gRunCodeInScriptStatus = true;
            if(button && !gGetCommandIsEmpty)
                button.textContent = window.LanguageManager.getTranslatedText("Stop");
            if(editbutton && !gGetCommandIsEmpty)
                editbutton.disabled = true;

            const getAllWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
            let getcurrentOrderIds = Array.from(getAllWrappers).map(wrapper => wrapper.getAttribute('data-id'));
            let getorderedSelectedIds = getcurrentOrderIds.filter(id => selectedIds.includes(id));
            let getorderedNotSelectedIds = getcurrentOrderIds.filter(id => !selectedIds.includes(id));
            if(!gGetCommandIsEmpty)
            {
                for (const id of getorderedNotSelectedIds) 
                {
                    const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
                    const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
                    otherWrapper.classList.add("fade-color");
                    otherWrapper.classList.remove("active-hover-effect");
                    modeText.classList.remove('show-modeText');
                }
            
                for (const id of getorderedSelectedIds) 
                {
                    const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
                    const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
                    otherWrapper.classList.remove("fade-color");
                    otherWrapper.classList.add("active-hover-effect");
                    modeText.classList.remove('show-modeText');
                }
            }
        }
    }
}

function AiDirector_updateSoundDeviceConnect(msg) {

    if (shouldStopExecution) 
    {
        var message = 'Stopping Device Connect !';
        if(document.getElementById('Result_Output-text'))
            document.getElementById('Result_Output-text').innerText = message;
        if(document.getElementById('Easymode_Result_Output-text'))
            document.getElementById('Easymode_Result_Output-text').innerText = message;
        addMessage(message);
        return;
    }

    if (msg.Result == 'Success') 
    {
        gSoundDeviceConnectStatus[msg.SoundTabIndex] = 'Connect';
        eventEmitter.emit('updateSoundDeviceConnect', { status: 'Success', tabIndex: msg.SoundTabIndex });

    } 
    else 
    {
        gSoundDeviceConnectStatus[msg.SoundTabIndex] = 'Disconnect';
        eventEmitter.emit('updateSoundDeviceConnect', { status: 'Fail', tabIndex: msg.SoundTabIndex });
    }
}


let gMaxSoundPos = 0;
let gMaxPresetShowNum = 0;
let gNowSoundTabIndex = 0;

function AiDirector_updateGetSoundPos(msg) {    
    gsoundPosStatus[msg.SoundTabIndex + '_' + msg.PosIndex] = msg.IsOn;

    if(gsoundPosStatus[msg.SoundTabIndex + '_' + msg.PosIndex] == true)
    {
        gMaxSoundPos = msg.PosIndex;
    }
    if(gMaxPresetShowNum != 0)
    {
        var AllPosOff = 0;
        for(let arrayPos = 0;arrayPos<gMaxPresetShowNum;arrayPos++)
        {
            var key = msg.SoundTabIndex + '_' + arrayPos;
            
            if(gsoundPosStatus[key] == true)
            {
                AllPosOff=0;
                return;
            }
        }
        AllPosOff=1;
        gMaxSoundPos=gMaxPresetShowNum;
    }
}


function AiDirector_updateSoundNumbers(msg) {
    AIBoxState.Sound.SoundNumbers = msg.SoundNumbers;
    AiDirector_sendMessage('GetSoundSettingForDirector');
    AiDirector_sendMessage('GetSoundAdvanceSettingForDirector');
}

function AiDirector_updateSoundSetting(msg) {
    //console.log('AiDirector_updateSoundSetting msg->',msg);
    for(let soundIndex = 0;soundIndex < msg.SoundNumbers;soundIndex++)
    {
        // console.log('msg.SoundSettingArray[',soundIndex,'] -- >',msg.SoundSettingArray[soundIndex]);
        if (AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex] === undefined) {
            AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex] = {
                SoundTabIndex: msg.SoundSettingArray[soundIndex].SoundTabIndex,
                Microphone: {
                    SoundDeviceIndex: 0, 
                    ConnectActionStatus: "Unconnect",
                    IPAddress: "",
                    Password: "",
                    Port: 0,
                    isConnect: false,
                },
                Advance: {
                    AudioTriggerLevel: 0,
                    BackToHomePos: 0,
                    BackToHomePreset: 0,
                    BackToHomeSwitchCamera: 'All',//window.LanguageManager.getTranslatedText("All_Camera")
                    BackToHomeTime: 0,
                    TimeToTriggerPreset: 0,
                },
                RangeArray:{

                },
            };
        }

        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.SoundDeviceIndex       = getMicSelectIndexByDeviceIndex(msg.SoundSettingArray[soundIndex].SoundSetting.MicDeviceIndex);
        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.ConnectActionStatus    = msg.SoundSettingArray[soundIndex].SoundSetting.ConnectActionStatus;
        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.Port                   = msg.SoundSettingArray[soundIndex].SoundSetting.Port;
        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.IPAddress              = msg.SoundSettingArray[soundIndex].SoundSetting.IPAddress;
        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.Password               = msg.SoundSettingArray[soundIndex].SoundSetting.Password;
        AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.isConnect              = msg.SoundSettingArray[soundIndex].SoundSetting.isConnect;
        
        if (AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex].Microphone.isConnect) 
        {
            if(arraysEqual(gMicrophoneSelectOptionNew, gMicrophoneSelectOptionNewDefalut) &&
            arraysEqual(gTabSelectOptionNew, gTabSelectOptionNewDefalut))
            {
                gMicrophoneSelectOptionNew.length = 0;
                gTabSelectOptionNew.length = 0;    
            }
            var deviceName = getDeviceNameByIndex(msg.SoundSettingArray[soundIndex].SoundTabIndex,getMicSelectIndexByDeviceIndex(msg.SoundSettingArray[soundIndex].SoundSetting.MicDeviceIndex)+1, msg.SoundSettingArray[soundIndex].SoundSetting.IPAddress);
            var deviceIndex = (parseInt(msg.SoundSettingArray[soundIndex].SoundTabIndex) + 1).toString();

            addDeviceOption(deviceName, deviceIndex);

            gTabSelectOptionNew.push([(parseInt(msg.SoundSettingArray[soundIndex].SoundTabIndex) + 1).toString(), (parseInt(msg.SoundSettingArray[soundIndex].SoundTabIndex) + 1).toString()]);
            const nullDeviceIndex = gMicrophoneSelectOptionNew.findIndex(option => option[1] === "99");
            if (nullDeviceIndex !== -1) {
                gMicrophoneSelectOptionNew.splice(nullDeviceIndex, 1);
            }
            gMicrophoneSelectOptionNew.push(["Null Device", "99"]);
        }

        // console.log('AiDirector_updateSoundSetting-->',AIBoxState.Tab[msg.SoundSettingArray[soundIndex].SoundTabIndex]);
    } 
}

function AiDirector_updateAdvanceSetting(msg){
    //console.log('AiDirector_updateAdvanceSetting --> ',msg);
    
    for(let soundIndex = 0;soundIndex < msg.SoundNumbers;soundIndex++)
    {
        // console.log('msg.SoundAdvanceSettingArray[',soundIndex,'] -- >',msg.SoundAdvanceSettingArray[soundIndex]);
        if (AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex] === undefined) {
            AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex] = {
                SoundTabIndex: msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex,
                Microphone: {
                    SoundDeviceIndex: 0, 
                    ConnectActionStatus: "Unconnect",
                    IPAddress: "",
                    Password: "",
                    Port: 0,
                    isConnect: false,
                },
                Advance: {
                    AudioTriggerLevel: 0,
                    BackToHomePos: 0,
                    BackToHomePreset: 0,
                    BackToHomeSwitchCamera: 'All',//window.LanguageManager.getTranslatedText("All_Camera")
                    BackToHomeTime: 0,
                    TimeToTriggerPreset: 0,
                },
                RangeArray:{

                },
            };
        }

        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.AudioTriggerLevel         = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.AudioTriggerLevel;     
        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.BackToHomePos             = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.BackToHomePos;         
        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.BackToHomePreset          = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.BackToHomePreset;      
        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.BackToHomeSwitchCamera    = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.BackToHomeSwitchCamera;
        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.BackToHomeTime            = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.BackToHomeTime;        
        AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex].Advance.TimeToTriggerPreset       = msg.SoundAdvanceSettingArray[soundIndex].soundAdvanceSetting.TimeToTriggerPreset;   
    
        // console.log('AiDirector_updateAdvanceSetting-->',AIBoxState.Tab[msg.SoundAdvanceSettingArray[soundIndex].SoundTabIndex]);
    }

}

function addDeviceOption(deviceName, deviceIndex) {
    let exists = gMicrophoneSelectOptionNew.some(function(item) {
        return item[0] === deviceName && item[1] === deviceIndex;
    });

    if (!exists) {
        gMicrophoneSelectOptionNew.push([deviceName, deviceIndex]);
    }
}

function getDeviceNameByIndex(SoundTabIndex,soundDeviceIndex, ipAddress) {
    var deviceIndex = soundDeviceIndex.toString();
    return `${SoundTabIndex+1}.${microphoneMap[deviceIndex]}:${ipAddress}`;
}

function arraysEqual(arr1, arr2) {
    if (arr1.length !== arr2.length) return false;
    for (let i = 0; i < arr1.length; i++) {
        if (arr1[i][0] !== arr2[i][0] || arr1[i][1] !== arr2[i][1]) {
            return false;
        }
    }
    return true;
}

function AiDirector_updateGetCameraList(msg) {
    let cameraDataList = msg.CamerasArray;
    if (shouldStopExecution) {
        var message = 'Stopping Camera List Update!';
        if(document.getElementById('Result_Output-text'))
            document.getElementById('Result_Output-text').innerText = message;
        if(document.getElementById('Easymode_Result_Output-text'))
            document.getElementById('Easymode_Result_Output-text').innerText = message;
        addMessage(message);
        return;
    }

    let newOptions = [];
    let newOptions_lite = [];

    for (var i = 0; i < cameraDataList.length; i++) {
        let cameraData = cameraDataList[i];
        let ipAddress = cameraData.IPAddress;
        let friendlyName = cameraData.FriendlyName || cameraData.ModelName;
        let connectStatus = cameraData.ConnectStatus === 'Connected' ? 'Connected' : 'Disconnected';
        

        let fullValue = `${friendlyName}(${ipAddress})`;
        if(connectStatus ==='Connected')
        {
            newOptions.push([fullValue, ipAddress]);
            newOptions_lite.push([friendlyName, ipAddress]);
        }

    }
    newOptions.push(["Null", "0"]);
    newOptions_lite.push(["Null", "0"]);
    
    latestCameraOptions = newOptions;
    latestCameraOptions_lite = newOptions_lite;

    refreshDropdowns();
    
    eventEmitter.emit('updateCameraList', { status: 'Done' });
}



function getDeviceChannelType(soundDeviceIndex) {
    const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === soundDeviceIndex);
    const config = deviceChannelConfig[deviceName];
    return config ? config.channelType : 'preset';
}

function generatePresetChannelOptions(soundTabIndex, soundCamMap) {
    const options = [];
    for (let index = 0; index < soundCamMap.PresetShowNum; index++) {
        if (soundCamMap.PresetLinkMap.MapArray[index]) {
            options[index] = [
                (soundCamMap.PresetLinkMap.MapArray[index].PosIndex + 1).toString(),
                soundCamMap.PresetLinkMap.MapArray[index].PosIndex.toString()
            ];
        }
    }
    return options;
}

function generateAzimuthChannelOptions(soundTabIndex, soundCamMap) {
    const options = [];
    for (let index = 0; index < soundCamMap.PresetShowNum; index++) {
        if (soundCamMap.AzimuthRange.RangeArray[index]) {
            options[index] = [
                soundCamMap.AzimuthRange.RangeArray[index].From + ' ~ ' + soundCamMap.AzimuthRange.RangeArray[index].To,
                soundCamMap.AzimuthRange.RangeArray[index].RangeIndex.toString()
            ];
        }
    }
    return options;
}

function isPresetChannelDevice(soundDeviceIndex) 
{
    return getDeviceChannelType(soundDeviceIndex) === 'preset';
}

function isAzimuthChannelDevice(soundDeviceIndex) 
{
    return getDeviceChannelType(soundDeviceIndex) === 'azimuth';
}

function AiDirector_updateCameraMapping(msg){

    if(msg.AllCamMapArray)
    {
        getSoundAllSetForAIDirector = false;
        if(document.getElementById('IndexMicSchedule'))
            document.getElementById('IndexMicSchedule').textContent = 100;
        UnblockUIforPage();
        msg.AllCamMapArray.forEach(camMap => {

            const soundTabIndex = camMap.SoundTabIndex;
            const soundCamMap = camMap.SoundCamMap;

            if (AIBoxState.Tab[soundTabIndex] === undefined) {
                AIBoxState.Tab[soundTabIndex] = {
                    SoundTabIndex: soundTabIndex,
                    Microphone: {
                        SoundDeviceIndex: 0,
                        ConnectActionStatus: "Unconnect",
                        IPAddress: "",
                        Password: "",
                        Port: 0,
                        isConnect: false,
                    },
                    Advance: {
                        AudioTriggerLevel: 0,
                        BackToHomePos: 0,
                        BackToHomePreset: 0,
                        BackToHomeSwitchCamera: 'All',//window.LanguageManager.getTranslatedText("All_Camera")
                        BackToHomeTime: 0,
                        TimeToTriggerPreset: 0,
                    },
                    RangeArray: {},
                    PresetLinkMap: {},
                };
            }

            if (soundCamMap.PresetLinkMap && soundCamMap.PresetLinkMap.MapArray) {
                AIBoxState.Tab[soundTabIndex].PresetLinkMap = soundCamMap.PresetLinkMap.MapArray;
            }

            if (soundCamMap.AzimuthRange && soundCamMap.AzimuthRange.RangeArray) {
                AIBoxState.Tab[soundTabIndex].RangeArray = soundCamMap.AzimuthRange.RangeArray;
            } 
            else 
            {
                AIBoxState.Tab[soundTabIndex].RangeArray = [];
                for (let index = 0; index < soundCamMap.PresetShowNum; index++) 
                {
                    AIBoxState.Tab[soundTabIndex].RangeArray[index] = { RangeIndex: index };
                }
            }

            const SoundDeviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
            const channelType = getDeviceChannelType(SoundDeviceIndex);

            gMicrophoneSelectChannelOption[soundTabIndex] = [];

            switch (channelType) 
            {
                case 'preset':
                    gMicrophoneSelectChannelOption[soundTabIndex] = generatePresetChannelOptions(soundTabIndex, soundCamMap);
                    break;
                case 'azimuth':
                    gMicrophoneSelectChannelOption[soundTabIndex] = generateAzimuthChannelOptions(soundTabIndex, soundCamMap);
                    break;
                default:
                    console.warn(`Unknown channel type: ${channelType} for device index: ${SoundDeviceIndex}`);
                    gMicrophoneSelectChannelOption[soundTabIndex] = generatePresetChannelOptions(soundTabIndex, soundCamMap);
                    break;
            }

            gMaxPresetShowNum = soundCamMap.PresetShowNum;
            gNowSoundTabIndex = soundTabIndex;

            let cameraItemArray = soundCamMap.CameraSelectItems.CameraItemArray;
            let newOptions = [];
            let newOptions_lite = [];

            for (let i = 0; i < cameraItemArray.length; i++) {
                let fullValue = cameraItemArray[i].Camera;

                let ipRegex = /\b(?:\d{1,3}\.){3}\d{1,3}\b/;
                let match = fullValue.match(ipRegex);
                let cameraName = fullValue.replace(ipRegex, '').trim().replace(/\((.*?)\)$/, '').trim();

                if (match && match.length > 0) {
                    let ip = match[0];
                    newOptions.push([fullValue, ip]);
                    newOptions_lite.push([fullValue, ip]);
                }
            }

            newOptions.push(["Null", "0"]);
            newOptions_lite.push(["Null", "0"]);
            latestCameraOptions = newOptions;
            latestCameraOptions_lite = newOptions_lite;

            refreshDropdowns();
        });

        eventEmitter.emit('updateCameraMapping', { status: 'Done' });
    }
}

function AiDirector_updateCamConnect(msg) {    
}
function AiDirector_updateVideoResolution(msg){
}
function AiDirector_updateVideoFps(msg){
}
function AiDirector_updateGetVoiceTracking(msg){
}
function AiDirector_updateSoundDevicePort(msg){
}
function AiDirector_updatedGetStandByStatus(msg){
}
function AiDirector_updatedPTZFocusMode(msg){
}
function AiDirector_GetMirrorFlipType(msg){
}
function AiDirector_updatedPanFlip(msg){
}

function AiDirector_updatedGetAIDirectorProfileData(msg){
    let Profile = document.getElementById('Select_Profile');
    
    if(Profile.value != msg.ProfileIndex)
    {
        // sendMessageIndex("GetAllProfile");
        // sendMessageIndex("GetCurrentProfileID");
        let Programming_Workspace = document.getElementById('Programming_Workspace_Div');
        Programming_Workspace.style.display = 'none';
        return;
    }

    if (msg.AllProfile && gGetProfileTempData)
    {
        
        
        if(document.getElementById('IndexSchedule'))
            document.getElementById('IndexSchedule').textContent = 100;

        gGetProfileTempData = false;
        getAIDirectorBlockUIPage = false;
        gUpdateXMLProfile = true;
        gNowGetProfileIndex = 0;
        gNowGetMicrophoneSettingResponseCount = 0;
        UnblockUIforPage();
        getSoundAllSetForAIDirector = true;

        setTimeout(function() {
            blockUIforPage();
            if(document.getElementById('IndexSchedule'))
                document.getElementById('IndexSchedule').textContent = 0;
            AiDirector_sendMessage("GetSoundCamMapForDirector");
        }, 50);

        for(let configFileIndex = 0 ;configFileIndex < msg.AllProfile.length ; configFileIndex ++)
        {
            if (!gProfileData[msg.ProfileIndex]) 
            {
                gProfileData[msg.ProfileIndex] = {};
            }

            gProfileData[msg.ProfileIndex][configFileIndex] = {
                xmlData: msg.AllProfile[configFileIndex].AIDirectorXML,
                updated: true
            };

        }

        let DirectorNormalMode_edit = document.getElementById('DirectorNormalMode-editChanges');
        let DirectorNormalMode_log = document.getElementById('Easymode_execution_msg_btn');
        let DirectorNormalMode_run = document.getElementById('DirectorNormalMode-codestaus');
        let DirectorEnable = document.getElementById('Label_SetEnableDirector');
        let DirectorEnableSwitchonoff = document.getElementById('SetEnableDirectorSwitchonoff');
        let DirectorEnableContainer = document.getElementById('btnEnableDirectorContainer');

        DirectorNormalMode_run.style.display  = 'block';
        DirectorNormalMode_edit.style.display = 'block';
        DirectorNormalMode_log.style.display  = 'block';
        DirectorEnable.style.display  = 'block';
        DirectorEnableSwitchonoff.style.display  = 'block';
        if(!gEnableDirectorStatus)
            DirectorEnableContainer.style.display  = 'block';
    }

    if (msg.AIDirectorXML && !gProfileResponseReceived && !gGetProfileTempData)
    {
        UnblockUIforPage();
        var Programming_Workspace = document.getElementById('Programming_Workspace_Div');

        if(!gGetProfileNoDisplayWorkspace){
            Programming_Workspace.style.display = 'none';
        }
        gProfileRetryCount = 0; 
        initBlockly();
        if (shouldRunCode) { 
            runCode(); 
            if ($(".Director_Btn").hasClass('inactive')) 
            {
                $(".Director_Btn").removeClass('inactive').addClass('active');
            }
            setTimeout(() => {
                gDirectorCheckInterval = setInterval(() => {
                    sendCheckDirectorRunCommand();
                }, 200);
            },100);
        }

        profile1XmlString = msg.AIDirectorXML;
        profile1XmlString = decryptXmlString(profile1XmlString);

        gProfileResponseReceived = true;
        clearInterval(gProfileRetryTimer);

        var message = 'Load File'+msg.Status+'!';
        if(document.getElementById('Result_Output-text'))
            document.getElementById('Result_Output-text').innerText = message;
        if(document.getElementById('Easymode_Result_Output-text'))
            document.getElementById('Easymode_Result_Output-text').innerText = message;
        addMessage(message);
        updateWorkspaceWithProfileData();

        if(gEasyModeRunWithoutWorkSpace)
        {
            gEasyModeRunWithoutWorkSpace = false;
            checkRunCodeStatus();
        }
    }
}

function AiDirector_updatedSetAIDirectorProfileData(msg){
    updateProfileSaveMessage(true);
}

function AiDirector_sendMessage(cmd,data) {

    var msg = cmd;

    if ( AiDirector_websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "AddCamera"){
            jsonmsg.IPAddress = data; //AddCamera
        }     
        // else if(msg == "GetSoundCamMapForDirector"){
        //     jsonmsg.SoundTabIndex = data;
        // }
        else if(msg == "GetCamAISetting"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetSoundNumbers"){
            jsonmsg.SoundNumbers = data;
        }
        else if(msg == "SetSoundAdvanceSetting" || msg == "SetSoundSetting" || msg == "SetSoundDeviceType"){
            jsonmsg = data;
        }
        else if(msg == "SoundConnect" || msg == "SoundDisconnect"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "SetSoundCamMap"){
            jsonmsg = data;
        }
        else if(msg == "SetCamAISetting"){
            jsonmsg = data;
        }
        else if(msg == "CameraConnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "CameraDisconnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetVideoResolution"){
            jsonmsg.VideoResolution = data;
        }
        else if(msg == "SetVideoFps"){
            jsonmsg.VideoFps = data;
        }
        else if(msg == "SetVoiceTracking"){
            jsonmsg.Status = data;
        }
        else if(msg == "GetSoundDevicePort"){
            jsonmsg = data;
        }
        else if(msg == "GetFocusMode" || msg == "GetMirrorFlipType" || msg == "GetPanFlip"){
            jsonmsg = data;
        }
        else if(msg == "SetPanTiltStart" || msg == "SetPanTiltStop" || msg == "SetPanTiltHome"){
            jsonmsg = data;
        }
        else if(msg == "SetFocusStop" || msg == "SetFocusStart"){
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart"){
            jsonmsg = data;
        }
        else if(msg == "SetMirrorFlip" || msg == "SetPanFlip" || msg == "SetFocusMode"){
            jsonmsg = data;
        }
        else if(msg == "SetToCallPreset" || msg == "SetToSavePreset"){
            jsonmsg = data;
        }
        else if(msg == 'SetAIDirectorProfileDataForDirector'){
            jsonmsg = data;
        }
        else if(msg == 'GetAIDirectorProfileDataForDirector'){
            jsonmsg = data;
        }
        else if(msg == 'SetAIDirectorAutoProfileDataForDirector'){
            jsonmsg = data;
        }
        else if (msg == "SetSystemSetting") {
            jsonmsg = data;
        }

        //var jsonmsg = {
        //   Command : msg
            //ws_msg : msg//"49.138077,-122.857472"
        //};
        if (AiDirector_websocket.readyState == 1) {
        AiDirector_websocket.send( JSON.stringify(jsonmsg) );
            //console.log('AiDirector_websocket send msg -->',msg,' jsonmsg -->',jsonmsg);
        }
        else {
        }
    }
}

function initBlockly() {
    
    var editbuttondisabled = document.getElementById('DirectorNormalMode-editChanges');
    var runbuttondisabled = document.getElementById('DirectorNormalMode-codestaus');
    if(selectedButtonId == null)
    {
        gEditScriptID = -1;
        if(editbuttondisabled)
            editbuttondisabled.disabled=true;
        if(runbuttondisabled)
            runbuttondisabled.disabled=true;
    }
    else
    {
        gEditScriptID = defaultbtnTexts.indexOf(selectedButtonId);
        if(!gExecutionStatus)
        {
            runbuttondisabled.textContent = window.LanguageManager.getTranslatedText("Run");
            if ($(".Director_Btn").hasClass('active')) 
            {
                $(".Director_Btn").removeClass('active').addClass('inactive');
            }
        }
        if(runbuttondisabled)
            runbuttondisabled.disabled=false;
    }

    var Result_Output = document.getElementById('Result_Output-text');
    if (workspace) {
        workspace.dispose();
    }
    

    if(gAIDirectorSelectedIndex == 0)
    {
        if(document.getElementById("GobalSelectLanguage").value == 0)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox2_en'),
                    collapse: false,
                    comments: false, 
                    scrollbars: true
                });
            document.getElementById('toolbox2_en').style.display = 'block';
        }
        else if(document.getElementById("GobalSelectLanguage").value == 1)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox2_tw'),
                    collapse: false,
                    comments: false, 
                    scrollbars: true
                });
            document.getElementById('toolbox2_tw').style.display = 'block';
        }
        else if(document.getElementById("GobalSelectLanguage").value == 2)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox2_zh'),
                    collapse: false,
                    comments: false, 
                    scrollbars: true
                });
            document.getElementById('toolbox2_zh').style.display = 'block';
        }
        
    }
    else
    {
        if(document.getElementById("GobalSelectLanguage").value == 0)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox1_en'),
                    collapse: false,
                    comments: false,
                    scrollbars: true
                });
        }
        else if(document.getElementById("GobalSelectLanguage").value == 1)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox1_tw'),
                    collapse: false,
                    comments: false,
                    scrollbars: true
                });
        }
        else if(document.getElementById("GobalSelectLanguage").value == 2)
        {
                workspace = Blockly.inject('blocklyDiv', {
                    toolbox : document.getElementById('toolbox1_zh'),
                    collapse: false,
                    comments: false,
                    scrollbars: true
                });
        }

    }

    initializeBlocklyZoom();

    if(Result_Output)
    {
        if(Result_Output.innerText == "")
            Result_Output.className = "";
        else
            Result_Output.className = "Result_Output-text-onborder";
    }

        workspace.addChangeListener(function(event) {
            if (event.type == Blockly.Events.BLOCK_CREATE) {
                event.ids.forEach(function(id) {
                    setTimeout(function() {
                        var block = workspace.getBlockById(id);

                        if (block && block.type === 'StartBlockly') {
                            const newUniqueId = generateUniqueId();
                            const currentMaxPriority = scriptList.length + 1;
                            block.setFieldValue(currentMaxPriority, 'Priority');
                            block.setFieldValue(newUniqueId, 'UNIQUE_ID');
                            createOrUpdateScript(newUniqueId, currentMaxPriority);
                        }

                        if (block && ['EndBlockly','ConnectBlockly','StopBlockly', 'ConnectBlockly', 'CallCameraPresetWithList', 'SetCameraPresetSpeedWithList', 
                        'CallCameraHomeWithList', 'SendCameraHEXCommands', 'CallMultiCameraPresetCruise', 'AfterReschedule','DelayMs','DelayS','DelayS',
                        'RepeatCount', 'SetVideoSourceLayout', 'SetVideoSourcePosition','SetSeamlessSwitching', 'get_sound_pos', 'get_sound_pos2','TriggerConditions','TriggerConditions1by3'].includes(block.type)) 
                        {
                            const newUniqueId = generateUniqueId();
                            block.setFieldValue(newUniqueId, 'UNIQUE_ID');

                            if (block.type === 'get_sound_pos2') {
                                const newUniqueId2 = generateUniqueId();
                                block.setFieldValue(newUniqueId2, 'UNIQUE_ID2');
                            }
                        }

                    }, 0);
                })    
            }

            if (event.type == Blockly.Events.BLOCK_DELETE) {
                event.ids.forEach(function(id) {
                    var block = event.oldXml;
                    if (block) {
                        var blockType = block.getAttribute('type');
                        if (blockType === 'StartBlockly') {
                            deleteScript(id);
                            updatePrioritiesAfterDeletion();
                        }
                    }
                });
            }
            if (event.type == Blockly.Events.BLOCK_MOVE) {
                const block = workspace.getBlockById(event.blockId);
                if (block) {
                    const UNIQUE_ID = block.getFieldValue('UNIQUE_ID');
                
                    if (isBlockDisconnected(block)) {
                        handleBlockDisconnect(block);
                    } else {
                        handleBlockConnect(block);
                    }
            
                    checkBlockConnections(block);
                }
            }

            if (event.type == Blockly.Events.CLICK) 
            {
                const block = workspace.getBlockById(event.blockId);
            }
        });
}

function handleBlockConnect(block) {
    const startBlock = getConnectedStartBlock(block);
    if (startBlock) {
        const startPriority = startBlock.getFieldValue('Priority');
        block.setFieldValue(startPriority, 'Priority');
        updateScriptOrder();
    }
}

function handleBlockDisconnect(block) {
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    removeActionFromList(uniqueId);
}

function removeActionFromList(uniqueId) {
    const originalLength = idActionList.length;
    idActionList = idActionList.filter(action => action.id !== uniqueId);
}

function checkBlockConnections(block) {
    if (block.outputConnection && block.outputConnection.isConnected()) {
        const targetBlock = block.outputConnection.targetBlock();
        const UNIQUE_ID = targetBlock.getFieldValue('UNIQUE_ID');
    }

    block.inputList.forEach(function(input) {
        if (input.connection && input.connection.isConnected()) {
            const connectedBlock = input.connection.targetBlock();
            const UNIQUE_ID = connectedBlock.getFieldValue('UNIQUE_ID');
        }
    });
    
    if (block.previousConnection && block.previousConnection.isConnected()) {
        const targetBlock = block.previousConnection.targetBlock();
        const UNIQUE_ID = targetBlock.getFieldValue('UNIQUE_ID');
    }

    if (block.nextConnection && block.nextConnection.isConnected()) {
        const targetBlock = block.nextConnection.targetBlock();
        const UNIQUE_ID = targetBlock.getFieldValue('UNIQUE_ID');
    }
}

function updateScriptOrder() {
    scriptList.sort((a, b) => a.priority - b.priority);
    for (let i = 0; i < scriptList.length; i++) 
    {
        scriptList[i].priority = i + 1;

        let block = workspace.getBlockById(scriptList[i].id);
        if (block) 
        {
            block.setFieldValue(scriptList[i].priority, 'Priority');
        }
    }
}

function isBlockDisconnected(block) {
    if (block.previousConnection && block.previousConnection.isConnected()) {
        return false;
    }
    if (block.nextConnection && block.nextConnection.isConnected()) {
        return false;
    }
    for (let i = 0; i < block.inputList.length; i++) {
        let input = block.inputList[i];
        if (input.connection && input.connection.isConnected()) {
            return false;
        }
    }
    return true;
}

function isConnectedToStartBlock(block) {
    if (!block) return false;

    if (block.type === 'StartBlockly') {
        return true;
    }

    if (block.previousConnection && block.previousConnection.isConnected()) {
        const previousBlock = block.previousConnection.targetBlock();
        return isConnectedToStartBlock(previousBlock);
    }

    return false;
}

function addMessage(message) {

    var messageBox = document.getElementById('Workspace_message');
    var messageBox2 = document.getElementById('Easymode_messageBox');
    var newMessage1 = document.createElement('div');
    newMessage1.style.marginLeft = '5px';
    var newMessage2 = document.createElement('div');
    newMessage2.style.marginLeft = '5px';
    
    var now = new Date();
    var timestamp = now.getFullYear() + '-' +
                   (now.getMonth() + 1).toString().padStart(2, '0') + '-' +
                    now.getDate().toString().padStart(2, '0') + ' ' +
                    now.getHours().toString().padStart(2, '0') + ':' +
                    now.getMinutes().toString().padStart(2, '0');
    newMessage1.innerHTML = timestamp + ' - ' + message + '\n';
    newMessage2.innerHTML = timestamp + ' - ' + message + '\n';
    
    const maxLines = 5000;

    if(messageBox)
        messageBox.appendChild(newMessage1);
    if(messageBox2)
        messageBox2.appendChild(newMessage2);

    if(messageBox)
    {
        while (messageBox.children.length > maxLines) {
            messageBox.removeChild(messageBox.firstChild);
        }
    }
    if(messageBox2)
    {
        while (messageBox2.children.length > maxLines) {
            messageBox2.removeChild(messageBox2.firstChild);
        }
    }
    if(messageBox)
        messageBox.scrollTop = messageBox.scrollHeight;
    if(messageBox2)
        messageBox2.scrollTop = messageBox2.scrollHeight;

}

async function runCode() {
    idActionList = [];
    var workspaceCode = Blockly.JavaScript.workspaceToCode(workspace);
    let jsonmsg = workspaceCode.split(';\n').filter(Boolean).map(JSON.parse);
    let changeJsonmsg = jsonmsg.filter(msg => idActionList.some(item => item.id === msg.id));

    var Profile = document.getElementById('Select_Profile');
    var jsonCommand = {};
    jsonCommand.Command         = "SetAIDirectorAutoProfileDataForDirector";
    jsonCommand.ScriptData      = JSON.stringify(changeJsonmsg);
    jsonCommand.ConfigFileIndex = gNowOpenProfileIndex;
    jsonCommand.ProfileIndex    = parseInt(Profile.value,10);
    AiDirector_sendMessage(jsonCommand.Command,jsonCommand);

    for (let msg of changeJsonmsg) {
        const blockId = msg.id;
        AiDirector_websocket.send(JSON.stringify(msg));
    }

    shouldStopExecution = false;
}

async function runProfileCode(workspaceCode) {
    shouldStopExecution = false;

    try {
        await eval(`(async () => { ${workspaceCode} })()`);
    } catch (e) {
    }
}
var profile1XmlString = ``;

function updateWorkspaceWithProfileData() {
    workspace.clear();
    //workspace.zoomToFit(); 
    workspace.setScale(1);
    var parser = new DOMParser();
    var doc = parser.parseFromString(profile1XmlString, "text/xml");
    Blockly.Xml.domToWorkspace(doc.documentElement, workspace);
}

const rules = {
    '<xml': '<x',
    '</xml>': '</x>',
    '<block': '<b',
    '</block>': '</b>',
    '<field': '<f',
    '</field>': '</f>',
    '<next': '<n',
    '</next>': '</n>',
    '<statement': '<st',
    '</statement>': '</st>',
    'id="': 'id_',
    'name="': 'nm_',
    'type="': 'tp_',
    'xmlns="https://developers.google.com/blockly/xml"': 'xmlns_@',
    'CallCameraPresetWithList': 'ccpl',
    'while_true': 'wt',
    'DelayS': 'dsb',
    'TAB_VALUE': 'tv',
    'CAMERA_VALUE': 'cv',
    'CAMERA_VALUE1': 'cv1',
    'DELAY_TIME': 'dt',
    'PRESET_VALUE': 'pv',
    'PRESET_VALUE0': 'pv0',
    'PRESET_VALUE1': 'pv1',
    'UNIQUE_ID': 'uid',
    'UNIQUE_ID1': 'uid1',
    'UNIQUE_ID2': 'uid2',
    'CallCameraHomeWithList': 'cchl',
    'SetVideoSourcePosition_with_list_image_Cross1x1': 'sspc1x1',
    'SetVideoSourcePosition_with_list_image_Cross1x2': 'sspc1x2',
    'SetVideoSourcePosition_with_list_image_Cross1x3': 'sspc1x3',
    'SetVideoSourcePosition_with_list_image_Cross2x2': 'sspc2x2',
};


function encryptXmlString(xmlString) {

    const idSimplifiedXmlString = xmlString.replace(/id="[^"]+"/g, () => `id="${generateRandomId(4)}"`);

    let encryptedString = idSimplifiedXmlString;
    for (const [key, value] of Object.entries(rules)) {
        const regex = new RegExp(key, "g");
        encryptedString = encryptedString.replace(regex, value);
    }
    return encryptedString;
}

function decryptXmlString(encryptedString) {
    let decryptedString = encryptedString;
    if(!decryptedString){return;}
    for (const [value, key] of Object.entries(rules)) {
        const regex = new RegExp(key, "g");
        decryptedString = decryptedString.replace(regex, value);
    }
    return decryptedString;
}

function generateRandomId(length) {
    const timestamp = Date.now().toString();
    const timePart = timestamp.substring(-2,2);
    const remainingLength = length - timePart.length;
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

    let randomPart = '';
    for (let i = 0; i < remainingLength; i++) {
        randomPart += characters.charAt(Math.floor(Math.random() * characters.length));
    }

    return timePart + randomPart;

}


function saveWorkspace() {
    var xml = Blockly.Xml.workspaceToDom(workspace);
    var xmlText = Blockly.Xml.domToText(xml);
    var filename = prompt(window.LanguageManager.getTranslatedText("Enter_file_name_to_save"), "blockly_workspace");
    if (filename) {
        download(xmlText, filename + ".xml", "text/xml");
    }
}

function download(text, name, type) {
    var a = document.createElement("a");
    var file = new Blob([text], { type: type });
    a.href = URL.createObjectURL(file);
    a.download = name;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

function loadFile(event) {
    var input = event.target;
    var reader = new FileReader();
    reader.onload = function() {
        try {
            workspace.clear();
            var parser = new DOMParser();
            var doc = parser.parseFromString(reader.result, "text/xml");
            Blockly.Xml.domToWorkspace(doc.firstChild, workspace);
            let msg = window.LanguageManager.getTranslatedText("File_loaded_successfully");
            alert(msg);
        } catch (e) {
            //console.error('Load XML error:', e);
            let msg = window.LanguageManager.getTranslatedText("File_loaded_XML_Failed");
            alert(msg);
        }
    };
    reader.readAsText(input.files[0]);
    input.value = "";
}

function changeLanguage() {
    var languageCode = document.getElementById('languageSelect').value;
    loadLanguage(languageCode);
}


function loadLanguage(langCode) {
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = '/blockly/msg/' + langCode + '.js';
    script.onload = function() {
        workspace.dispose();
        initBlockly();
    };
    document.head.appendChild(script);
}

function clearMessages() {
    var messageBox = document.getElementById('Workspace_message');
    var messageBox2 = document.getElementById('Easymode_messageBox');
    
    messageBox.innerHTML = '';
    messageBox2.innerHTML = '';
}

function saveMessages() {
    var messageBox = document.getElementById('Workspace_message');
    var textToSave = messageBox.textContent;
    var blob = new Blob([textToSave], { type: 'text/plain' });

    var fileNameInput = document.getElementById('msgFileName-input');
    var fileName;
    if(fileNameInput)
        fileName = fileNameInput.value.trim() || 'messages';

    var currentDate = new Date();
    var year = currentDate.getFullYear();
    var month = String(currentDate.getMonth() + 1).padStart(2, '0');
    var day = String(currentDate.getDate()).padStart(2, '0');
    var hours = String(currentDate.getHours()).padStart(2, '0');
    var minutes = String(currentDate.getMinutes()).padStart(2, '0');
    var formattedDate = year+month+day+hours+minutes;
    var fileName = 'ExecutionLog_'+formattedDate ;
    
    var a = document.createElement('a');
    a.href = URL.createObjectURL(blob);
    a.download = fileName + '.txt';
    a.click();
}



function zoomIn() {
    var workspaceScale = workspace.scale;
    workspace.setScale(workspaceScale * 1.1);
    workspace.scrollCenter();
    workspace.zoomToFit(); 
}


function zoomOut() {
    var workspaceScale = workspace.scale;
    workspace.setScale(workspaceScale / 1.1);
    workspace.scrollCenter();
    workspace.zoomToFit(); 
}

function resetZoom() {
    workspace.setScale(1);
    workspace.scrollCenter();
    workspace.zoomToFit(); 
}

//----------------Workspace.System.Function-------------------
var gPresetSpeedSelectOption = [
    ["5",  "0"],
    ["25", "1"],
    ["50", "2"],
    ["80", "3"],
    ["120","4"]
];

// let gMicrophoneSelectOption = [
//     ["Shure:MXA910", "1"],
//     ["Shure:MXA920", "2"],
//     ["Shure:MXA920(Coordinate)", "3"],
//     ["Shure:MXA710", "4"],
//     ["Shure:MXA310", "5"],
//     ["Shure:MXCW", "6"],
//     ["Shure:P300", "7"],
//     ["Sennheiser:TCC2", "8"],
//     ["Sennheiser:TCCM", "9"],
//     ["Sennheiser:TCC2(Coordinate)", "10"],
//     ["Sennheiser:TCCM(Coordinate)", "11"],
//     ["Nureva:HDL300", "12"],
//     ["Nureva:Dual HDL300", "13"],
//     ["Nureva:HDL310", "14"],
//     ["Nureva:HDL410", "15"],
//     ["Nureva:HDL410(Coordinate)", "16"],
//     ["Yamaha:RM-CG", "17"],
//     ["Yamaha:RM-CG(Coordinate)", "18"],
//     ["Yamaha:RM-W", "19"],
//     ["Yamaha:RM-CR", "20"],
//     ["Yamaha:RM-TT", "21"],
//     ["Audio-Technica:ATND1061", "22"],
//     ["Audio-Technica:ATND1061(Coordinate)", "23"],
//     ["Null Device", "99"]
// ];

let gMicrophoneSelectOption = [
    ["Shure:MXA910", "1"],
    ["Shure:MXA920", "2"],
    ["Shure:MXA920(Coordinate)", "3"],
    ["Shure:MXA710", "4"],
    ["Shure:MXA310", "5"],
    ["Shure:MXCW", "6"],
    ["Shure:P300", "7"],
    ["Sennheiser:TCC2", "8"],
    ["Sennheiser:TCCM", "9"],
    ["Sennheiser:TCC2(Coordinate)", "10"],
    ["Sennheiser:TCCM(Coordinate)", "11"],
    ["Nureva:HDL300", "12"],
    ["Nureva:Dual HDL300", "13"],
    ["Nureva:HDL310", "14"],
    ["Nureva:HDL410", "15"],
    ["Nureva:HDL410(Coordinate)", "16"],
    ["Yamaha:RM-CG", "17"],
    ["Yamaha:RM-CG(Coordinate)", "18"],
    ["Yamaha:RM-W", "19"],
    ["Yamaha:RM-CR", "20"],
    ["Yamaha:RM-TT", "21"],
    ["Audio-Technica:ATND1061", "22"],
    ["Audio-Technica:ATND1061(Coordinate)", "23"],
    ["Audio-Technica:ATUC-50CU", "24"],
    ["Televic:D-Cerno AE", "25"],
    ["Televic:D-Cerno AE(HTTPS)", "26"],
    ["Null Device", "99"]
];


let microphoneMap = {};
gMicrophoneSelectOption.forEach(function(item) {
    microphoneMap[item[1]] = item[0];
});

var gTabSelectOption = [
    ["1","1"]  ,["2","2"]  ,["3","3"]  ,["4","4"],
    ["5","5"]  ,["6","6"]  ,["7","7"]  ,["8","8"],
    ["9","9"]  ,["10","10"],["11","11"],["12","12"],
    ["13","13"],["14","14"],["15","15"],["16","16"],
    ["17","17"],["18","18"],["19","19"],["20","20"],
    ["21","21"],["22","22"],["23","23"],["24","24"],
];

let gMicrophoneSelectOptionNewDefalut = [
    ["Null Device", "99"]
];
let gTabSelectOptionNewDefalut = [
    ["Null connect Tab","99"]
];

let gMicrophoneSelectOptionNew = [
    ["Null Device", "99"]
];

let gMicrophoneSelectChannelOptionDefalut = [
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]]
];

let gMicrophoneSelectChannelOption = [
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],
    [["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]],[["Null Device", "99"]]
];

let gTabSelectOptionNew = [
    ["Null connect Tab","99"]
];

var gTriggerTimeSelectOption = [
    ["0.1s", "1"],
    ["0.3s", "3"],
    ["0.5s", "5"],
    ["1s", "10"],
    ["1.5s", "15"],
    ["2s", "20"],
    ["3s", "30"],
    ["4s", "40"],
    ["5s", "50"]
];

var gMicrophoneArrayAmount = 0;
var gCameraArrayAmount = 0;
//------------------------------AE-Camera-----------------------------------

Blockly.Blocks['CallMultiCameraPresetCruise'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Call_AB_Preset_Cruise")+": ","CRUISE_TITLE");

        this.appendEndRowInput()
        .appendField(window.LanguageManager.getTranslatedText("Select_Camera_Amount")+" : ")
        .appendField(new Blockly.FieldDropdown([
            ["2", "2"],["3", "3"],
            //["4", "4"]
        ], this.onCamAmountChange.bind(this)), "CAMERA_AMOUNT");

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Cruise_Mode")+": ")
        .appendField(new Blockly.FieldDropdown([
            ["1. "+window.LanguageManager.getTranslatedText("X_Y"), "1"],
            ["2. "+window.LanguageManager.getTranslatedText("X_start_X_end_Y_start_Y_end"), "2"],
        ], this.onCruiseModeChange.bind(this)), "CRUISE_MODE");

        this.inputCamRows = {};
        this.CruiseMode = 0;
        this.CamAmount = 0;
        for (let i = 1; i <= 4; i++) {
            if(i != 2){
                const CAM = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("CAM")+" A : ","CAMLABEL"+i)
                .appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE"+i);
                const PresetStart = this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Preset")+" A "+window.LanguageManager.getTranslatedText("start")+": ","PRESETLABEL_START"+i)
                    .appendField(new Blockly.FieldNumber(1, 0, 255), "PRESET_VALUE_START"+i);
                const PresetEnd = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Preset")+" A "+window.LanguageManager.getTranslatedText("end")+": ","PRESETLABEL_END"+i)
                    .appendField(new Blockly.FieldNumber(1, 0, 255), "PRESET_VALUE_END"+i);
                const PresetSpeed =  this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Preset_Speed")+" A : ","PRESETSPEEDLABEL"+i)
                    .appendField(new Blockly.FieldDropdown(gPresetSpeedSelectOption), "SPEED"+i).appendField(window.LanguageManager.getTranslatedText("deg_sec"));
                const Delay = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Delay"),"DELAY_LABEL"+i)
                    .appendField(new Blockly.FieldNumber(1, 0), "DELAY_TIME"+i).appendField(window.LanguageManager.getTranslatedText("s"),"DELAY_MODE"+i);

                CAM.setVisible(i<=2);
                PresetStart.setVisible(i<=2);
                PresetEnd.setVisible(i<=2);
                PresetSpeed.setVisible(i<=2);
                Delay.setVisible(i<=2);
                this.inputCamRows[i] = { CAM,PresetStart,PresetEnd, PresetSpeed,Delay};
            }else if(i == 2){
                const CAM = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("CAM")+" B : ","CAMLABEL"+i)
                    .appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE"+i);
                const PresetStart = this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Preset")+" B "+window.LanguageManager.getTranslatedText("start")+": ","PRESETLABEL_START"+i)
                    .appendField(new Blockly.FieldNumber(1, 0, 255), "PRESET_VALUE_START"+i);
                const PresetEnd = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Preset")+" B "+window.LanguageManager.getTranslatedText("end")+": ","PRESETLABEL_END"+i)
                    .appendField(new Blockly.FieldNumber(1, 0, 255), "PRESET_VALUE_END"+i);
                const PresetSpeed =  this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Preset_Speed")+" B : ","PRESETSPEEDLABEL"+i)
                    .appendField(new Blockly.FieldDropdown(gPresetSpeedSelectOption), "SPEED"+i).appendField(window.LanguageManager.getTranslatedText("deg_sec"));
                const Delay = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Delay"),"DELAY_LABEL"+i)
                    .appendField(new Blockly.FieldNumber(1, 0,1000), "DELAY_TIME"+i).appendField(window.LanguageManager.getTranslatedText("s"),"DELAY_MODE"+i);
                
                CAM.setVisible(i<=2);
                PresetStart.setVisible(i<=2);
                PresetEnd.setVisible(i<=2);
                PresetSpeed.setVisible(i<=2);
                Delay.setVisible(i<=2);
                this.inputCamRows[i] = { CAM,PresetStart,PresetEnd, PresetSpeed,Delay};
            }
        }
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#629FB0");
    },
    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    },
    onCruiseModeChange: function(newValue) {
        const newMode = parseInt(newValue);
        if(newMode == 1){
            for (let i = 1; i <= 4; i++) {
                const row = this.inputCamRows[i];
                if (row) {
                    row.PresetEnd.setVisible(false);
                    const PresetLabelStart = this.getField('PRESETLABEL_START' + i);
                    const PresetStart      = this.getField('PRESET_VALUE_START' + i);
                    const PresetEnd        = this.getField('PRESET_VALUE_END' + i);
                    if( i == 1){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' A : ');
                    }else if( i == 2){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' B : ');
                    }else if(i == 3){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' C : ');
                    }else if( i == 4){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' D : ');
                    }
                    PresetStart.setValue('1');
                    PresetEnd.setValue('2');
                }
            }
        }else{
            for (let i = 1; i <= 4; i++) {
                const row = this.inputCamRows[i];
                if (row) {
                    if(i <= CamAmount)
                        row.PresetEnd.setVisible(true);
                    const PresetLabelStart = this.getField('PRESETLABEL_START' + i);
                    const PresetStart      = this.getField('PRESET_VALUE_START' + i);
                    const PresetEnd        = this.getField('PRESET_VALUE_END' + i);
                    if( i == 1){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' A '+window.LanguageManager.getTranslatedText("Start")+': ');
                    }else if( i == 2){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' B '+window.LanguageManager.getTranslatedText("Start")+': ');
                    }else if(i == 3){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' C '+window.LanguageManager.getTranslatedText("Start")+': ');
                    }else if( i == 4){
                        PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' D '+window.LanguageManager.getTranslatedText("Start")+': ');
                    }
                    PresetStart.setValue('1');
                    PresetEnd.setValue('2');
                }
            }
        }   
    },
    onCamAmountChange: function(newValue) {
        const newAmount = parseInt(newValue);
        const CRUISE_TITLE  = this.getField('CRUISE_TITLE');
        CamAmount = newAmount;
        if(newAmount == 2){
            CRUISE_TITLE.setValue(window.LanguageManager.getTranslatedText("Call_Camera")+' A B '+window.LanguageManager.getTranslatedText("Preset")+' '+window.LanguageManager.getTranslatedText("Cruise")+' : ');
        }else if(newAmount == 3){
            CRUISE_TITLE.setValue(window.LanguageManager.getTranslatedText("Call_Camera")+' A B C '+window.LanguageManager.getTranslatedText("Preset")+' '+window.LanguageManager.getTranslatedText("Cruise")+' : ');
        }else if(newAmount == 4){
            CRUISE_TITLE.setValue(window.LanguageManager.getTranslatedText("Call_Camera")+' A B C D '+window.LanguageManager.getTranslatedText("Preset")+' '+window.LanguageManager.getTranslatedText("Cruise")+' : ');
        }
        for (let i = 1; i <= 4; i++) {
            const row = this.inputCamRows[i];
            if (row) {
                row.CAM.setVisible(i <= newAmount);
                row.PresetStart.setVisible(i <= newAmount);
                row.PresetEnd.setVisible(i <= newAmount);
                row.PresetSpeed.setVisible(i <= newAmount);
                row.Delay.setVisible(i <= newAmount);
                const CAMLabel         = this.getField('CAMLABEL' + i);
                const PresetLabelStart = this.getField('PRESETLABEL_START' + i);
                const PresetLabelEnd   = this.getField('PRESETLABEL_END' + i);
                const PresetSpeedLabel = this.getField('PRESETSPEEDLABEL' + i);
                if(newAmount == 2 && i == 2){
                    CAMLabel.setValue(window.LanguageManager.getTranslatedText("CAM")+' B : ');
                    PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' B '+window.LanguageManager.getTranslatedText("start")+' : ');
                    PresetLabelEnd.setValue(window.LanguageManager.getTranslatedText("Preset")+' B '+window.LanguageManager.getTranslatedText("end")+' : ');
                    PresetSpeedLabel.setValue(window.LanguageManager.getTranslatedText("Preset_Speed")+' B : ');
                }else if(newAmount == 3 && i == 3){
                    CAMLabel.setValue(window.LanguageManager.getTranslatedText("CAM")+' C : ');
                    PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' C '+window.LanguageManager.getTranslatedText("start")+' : ');
                    PresetLabelEnd.setValue(window.LanguageManager.getTranslatedText("Preset")+' C '+window.LanguageManager.getTranslatedText("end")+' : ');
                    PresetSpeedLabel.setValue(window.LanguageManager.getTranslatedText("Preset_Speed")+' C : ');
                }else if(newAmount == 4 && i == 4){
                    CAMLabel.setValue(window.LanguageManager.getTranslatedText("CAM")+' D : ');
                    PresetLabelStart.setValue(window.LanguageManager.getTranslatedText("Preset")+' D '+window.LanguageManager.getTranslatedText("start")+' : ');
                    PresetLabelEnd.setValue(window.LanguageManager.getTranslatedText("Preset")+' D '+window.LanguageManager.getTranslatedText("end")+' : ');
                    PresetSpeedLabel.setValue(window.LanguageManager.getTranslatedText("Preset_Speed")+' D : ');
                }
            }
        }
    },
};

Blockly.JavaScript.forBlock['CallMultiCameraPresetCruise'] = function(block) {
    const cameraAmount = parseInt(block.getFieldValue('CAMERA_AMOUNT'),10);
    const cruiseMode = parseInt(block.getFieldValue('CRUISE_MODE'),10);
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');

    addActionEntryIfConnectedToStart(block, 'CallMultiCameraPresetCruise');

    var cameaJSON = {};
    
    for (let index = 1; index <= cameraAmount; index++) {
        const cameraValue = block.getFieldValue('CAMERA_VALUE' + index);
        const PresetValueStart = parseInt(block.getFieldValue('PRESET_VALUE_START' + index), 10);
        const PresetValueEnd = parseInt(block.getFieldValue('PRESET_VALUE_END' + index), 10);
        const PresetSpeed = parseInt(block.getFieldValue('SPEED' + index), 10);
        const DelayTime = parseInt(block.getFieldValue('DELAY_TIME' + index), 10);

        let key = `cameaInfo${index}`;
        cameaJSON[key] = {
            ip: cameraValue,
            presetValueStart: PresetValueStart,
            presetValueEnd: PresetValueEnd,
            presetSpeed: PresetSpeed,
            delayTime: DelayTime,
            priority: priority
        };
    }

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SendMultiCameraPresetCruise',
        Params: {
            cameraAmount: cameraAmount,
            cruiseMode: cruiseMode, 
            cameaInfo: cameaJSON,
            priority: priority
        }
    }) + ';\n';
};

Blockly.Blocks['CallCameraPresetWithList'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);

        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Call_Camera")+" :").appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE");
        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Preset")).appendField(new Blockly.FieldNumber(1, 0, 255), "PRESET_VALUE");
        this.setTooltip(window.LanguageManager.getTranslatedText("Call_camera_preset_with_range")+" 0~255");
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#FF7050");
    },

    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    }
};

Blockly.JavaScript.forBlock['CallCameraPresetWithList'] = function(block){
    const cameraIP = block.getFieldValue('CAMERA_VALUE');
    const cameraShow = block.getField('CAMERA_VALUE').getText();
    const presetValue = block.getFieldValue('PRESET_VALUE');
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');

    addActionEntryIfConnectedToStart(block, 'CallCameraPresetWithList');

    return JSON.stringify({id: uniqueId,AIDirectorCmd: 'SendCameraPresetCmd',Params: {ip: cameraIP,cameraShow:cameraShow,preset: presetValue,priority: priority}})+';\n';
};

Blockly.Blocks['SetCameraPresetSpeedWithList'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Set_CAM")+" :").appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE");
        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Preset_Speed")+" : ")
        .appendField(new Blockly.FieldDropdown([["5 "+window.LanguageManager.getTranslatedText("deg_sec"), "0"],
                                                ["25 "+window.LanguageManager.getTranslatedText("deg_sec"), "1"],
                                                ["50 "+window.LanguageManager.getTranslatedText("deg_sec"), "2"],
                                                ["80 "+window.LanguageManager.getTranslatedText("deg_sec"), "3"],
                                                ["120 "+window.LanguageManager.getTranslatedText("deg_sec"), "4"]]), "PRESET_SPEED");
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#2080F0");
    },

    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    }
};

Blockly.JavaScript.forBlock['SetCameraPresetSpeedWithList'] = function(block) {
    const presetSpeed = parseInt(block.getFieldValue('PRESET_SPEED'),10); 
    const presetSpeedShow = block.getField('PRESET_SPEED').getText();
    const cameraValue= block.getFieldValue('CAMERA_VALUE');
    const cameraShow = block.getField('CAMERA_VALUE').getText();
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'SetCameraPresetSpeedWithList');

    return JSON.stringify(
        {
            id: uniqueId,
            AIDirectorCmd: 'SendCameraPresetSpeed',
            Params: {
                ip: cameraValue,
                cameraShow:cameraShow,
                presetSpeed: presetSpeed,
                presetSpeedShow:presetSpeedShow,
                priority: priority
            }
        }
    ) + ';\n';
};

Blockly.Blocks['CallCameraHomeWithList'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput()
            .appendField(window.LanguageManager.getTranslatedText("Call_Camera")+" :")
            .appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE");
        
        this.appendDummyInput()
            .appendField(window.LanguageManager.getTranslatedText("Back_To_Home"));

        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#FF7050");
    },
    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    }
};

Blockly.JavaScript.forBlock['CallCameraHomeWithList'] = function(block){
    const cameraIP = block.getFieldValue('CAMERA_VALUE');
    const cameraShow = block.getField('CAMERA_VALUE').getText();
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'CallCameraHomeWithList');
    return JSON.stringify({id: uniqueId,AIDirectorCmd: 'SendCameraHomeCmd',Params: {ip: cameraIP,cameraShow:cameraShow,priority: priority}})+';\n';
};

Blockly.Blocks['SendCameraHEXCommands'] = {

    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Select_Camera")+" : ").appendField(new Blockly.FieldDropdown(this.getCameraOptions), "CAMERA_VALUE");
        this.appendDummyInput()
            .appendField(window.LanguageManager.getTranslatedText("Send_HEX_Commands")+": ")
            .appendField(new Blockly.FieldTextInput("81010604FF", this.validateHex), "HEX_TEXT_INPUT");
        this.setColour("#FF7050");
        this.setTooltip(window.LanguageManager.getTranslatedText("Send_VISCA_Command"));
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.savedCharacters = "81010604FF".split('');  // Initialize with default value
    }
    ,getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    }
    ,validateHex: function(newValue) {
        const hexPattern = /^[0-9A-Fa-f]*$/;
        if (!this.savedCharacters) {
            this.savedCharacters = [];
        }
        for (let i = 0; i < newValue.length; i++) {
            const currentChar = newValue[i];
        
            if (hexPattern.test(currentChar)) {
                this.savedCharacters[i] = currentChar.toUpperCase();
            } else {

                newValue = this.savedCharacters.join('');
                break;
            }
        }
        this.oldValue = newValue.toUpperCase();
        return this.oldValue;
    }
};
Blockly.JavaScript.forBlock['SendCameraHEXCommands'] = function(block) {
    const hexCmd = block.getFieldValue('HEX_TEXT_INPUT');
    const cameraValue= block.getFieldValue('CAMERA_VALUE');
    const cameraShow = block.getField('CAMERA_VALUE').getText();
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');

    addActionEntryIfConnectedToStart(block, 'SendCameraHEXCommands');
    
    return JSON.stringify(
        {
            id: uniqueId,
            AIDirectorCmd: 'SendCameraHEXCommands',
            Params: {
                ip: cameraValue,
                cameraShow:cameraShow,
                hexCommand: hexCmd,
                priority: priority
            }
        }
    ) + ';\n';
};

Blockly.Blocks['DelayMs'] = {
    init: function() {
      const uniqueId = generateUniqueId();
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
      const currentPriority = scriptList.length + 1;
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
      this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Delay")).appendField(new Blockly.FieldNumber(1000, 100), "DELAY_TIME").appendField(window.LanguageManager.getTranslatedText("milliseconds"));
      this.setPreviousStatement(true,'script_connection');
      this.setNextStatement(true,'script_connection');
      this.setColour("#ED254E");
    }
};

Blockly.Blocks['DelayS'] = {
    init: function() {
      const uniqueId = generateUniqueId();
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
      const currentPriority = scriptList.length + 1;
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
      this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Delay")).appendField(new Blockly.FieldNumber(1, 0.1), "DELAY_TIME").appendField(window.LanguageManager.getTranslatedText("seconds"));
      this.setPreviousStatement(true,'script_connection');
      this.setNextStatement(true,'script_connection');
      this.setColour("#ED254E");
    }
};

Blockly.Blocks['DelayMin'] = {
    init: function() {
      const uniqueId = generateUniqueId();
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
      const currentPriority = scriptList.length + 1;
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
      this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Delay")).appendField(new Blockly.FieldNumber(1, 0.002), "DELAY_TIME").appendField(window.LanguageManager.getTranslatedText("minutes"));
      this.setPreviousStatement(true,'script_connection');
      this.setNextStatement(true,'script_connection');
      this.setColour("#ED254E");
    }
};

Blockly.JavaScript.forBlock['DelayMs'] = function(block){
    const delay_time = block.getFieldValue('DELAY_TIME');
    const delay_type = 0;
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'DelayMs');
    return JSON.stringify({id: uniqueId, AIDirectorCmd: 'SendDelayTimecmd',Params: {delayTime: delay_time,delayType: delay_type,priority: priority}})+';\n';
};

Blockly.JavaScript.forBlock['DelayS'] = function(block){
    const delay_time = block.getFieldValue('DELAY_TIME');
    const delay_type = 1;
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'DelayS');
    return JSON.stringify({id: uniqueId, AIDirectorCmd: 'SendDelayTimecmd',Params: {delayTime: delay_time,delayType: delay_type,priority: priority}})+';\n';
};

Blockly.JavaScript.forBlock['DelayMin'] = function(block){
    const delay_time = block.getFieldValue('DELAY_TIME');
    const delay_type = 2;
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    addActionEntryIfConnectedToStart(block, 'DelayMin');
    const priority = block.getFieldValue('Priority');
    return JSON.stringify({id: uniqueId, AIDirectorCmd: 'SendDelayTimecmd',Params: {delayTime: delay_time,delayType: delay_type,priority: priority}})+';\n';
}

let scriptList = [];

Blockly.Blocks['StartBlockly'] = {
  init: function() {
    const assignedPriority = scriptList.length + 1;
    const uniqueId = generateUniqueId();
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);

    this.appendDummyInput("SCRIPT_START")
        .appendField(window.LanguageManager.getTranslatedText("Script_Start"))
        .appendField(new Blockly.FieldNumber(assignedPriority, 1, 99), "Priority")
        .appendField(")");

    this.setNextStatement(true,['TriggerConditions1by3','TriggerConditions','script_connection','loop_script_connection']);
    this.setColour(120);
    this.setTooltip(window.LanguageManager.getTranslatedText("Script_Start"));
    this.setHelpUrl("");
  }
};

Blockly.JavaScript.forBlock['StartBlockly'] = function(block) {
  const priority = block.getFieldValue('Priority');  // Correct way to get field value
  const uniqueId = block.getFieldValue('UNIQUE_ID'); // Correct way to get field value

  addActionEntryIfConnectedToStart(block, 'StartBlockly');
  updateConnectedBlockPriorities(block, priority);
  return JSON.stringify({
      id: uniqueId,
      AIDirectorCmd: 'SendStartBlock',
      Params: {
          priority: priority,
      }
  }) + ';\n';
};

function updateConnectedBlockPriorities(block, newPriority) {
    if (block.nextConnection && block.nextConnection.isConnected()) {
        const nextBlock = block.nextConnection.targetBlock();
        if (nextBlock && nextBlock.getField("Priority")) {
            nextBlock.setFieldValue(newPriority, 'Priority');
            updateConnectedBlockPriorities(nextBlock, newPriority);
        }
    }
    
    block.inputList.forEach(function(input) {
        if (input.connection && input.connection.isConnected()) {
            const connectedBlock = input.connection.targetBlock();
            if (connectedBlock && connectedBlock.getField("Priority")) {
                connectedBlock.setFieldValue(newPriority, 'Priority');
                updateConnectedBlockPriorities(connectedBlock, newPriority);
            }
        }
    });
}

Blockly.Blocks['EndBlockly'] = {
  init: function() {
    const uniqueId = generateUniqueId();
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
    const currentPriority = scriptList.length + 1;
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
    this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Script_End"));

    this.setPreviousStatement(true,['TriggerConditions1by3','TriggerConditions','script_connection','loop_script_connection_end']);
    this.setColour(120);
    this.setTooltip(window.LanguageManager.getTranslatedText("Script_End"));
    this.setHelpUrl("");
  }
};
  
Blockly.JavaScript.forBlock['EndBlockly'] = function(block) {
  const uniqueId = block.getFieldValue('UNIQUE_ID'); // Correct way to get field value
  const priority = block.getFieldValue('Priority');
  addActionEntryIfConnectedToStart(block, 'EndBlockly');
  return JSON.stringify({
      id: uniqueId,
      AIDirectorCmd: 'SendEndBlock',
      Params: {
        priority: priority 
      }
  }) + ';\n';
};

Blockly.Blocks['StopBlockly'] = {
  init: function() {
    const uniqueId = generateUniqueId();
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
    const currentPriority = scriptList.length + 1;
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
    this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Script_Stop"));

    this.setPreviousStatement(true,['TriggerConditions1by3','TriggerConditions','script_connection']);
    this.setColour(200);
    this.setTooltip(window.LanguageManager.getTranslatedText("Script_Stop"));
    this.setHelpUrl("");
  }
};
  
Blockly.JavaScript.forBlock['StopBlockly'] = function(block) {
  const uniqueId = block.getFieldValue('UNIQUE_ID'); // Correct way to get field value
  const priority = block.getFieldValue('Priority');
  addActionEntryIfConnectedToStart(block, 'StopBlockly');
  return JSON.stringify({
      id: uniqueId,
      AIDirectorCmd: 'SendStopBlock',
      Params: {
        priority: priority
      }
  }) + ';\n';
};
  
Blockly.Blocks['ConnectBlockly'] = {
  init: function() {
    const assignedPriority = scriptList.length + 2;
    const uniqueId = generateUniqueId();
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
    const currentPriority = scriptList.length + 1;
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
    
    this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Script_next_execution"));
    this.setColour(180);
    this.setPreviousStatement(true, null);
    this.setTooltip(window.LanguageManager.getTranslatedText("Script_next_execution"));
    this.setHelpUrl("");
  }
};

Blockly.JavaScript.forBlock['ConnectBlockly'] = function(block) {
    const priority = block.getFieldValue('Priority');
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    addActionEntryIfConnectedToStart(block, 'ConnectBlockly');
    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SendConnectionBlock',
        Params: {
            priority:priority,
        }
    }) + ';\n';
};

function createOrUpdateScript(blockId) {
    let block = workspace.getBlockById(blockId);
    const startBlock = getConnectedStartBlock(block);
    if (!startBlock) {
        return;
    }

    const startPriority = startBlock.getFieldValue('Priority');

    let existingScript = scriptList.find(script => script.id === blockId);
    if (existingScript) {
        existingScript.priority = parseInt(startPriority);
    } else {
        scriptList.push({ id: blockId, priority: parseInt(startPriority) });
    }

    reorderScriptList();
}

function getConnectedStartBlock(block) {
    if (!block) return null;

    if (block.type === 'StartBlockly') {
        return block;
    }

    if (block.previousConnection && block.previousConnection.isConnected()) {
        const previousBlock = block.previousConnection.targetBlock();
        return getConnectedStartBlock(previousBlock);
    }

    return null;
}

function deleteScript(blockId) {
    const originalLength = scriptList.length;
    scriptList = scriptList.filter(script => script.id !== blockId);
    reorderScriptList();
}


function updatePrioritiesAfterDeletion() {
    // Reassign priorities to maintain a continuous sequence
    for (let i = 0; i < scriptList.length; i++) {
        scriptList[i].priority = i + 1;

        // Update the corresponding block's priority in the workspace
        let block = workspace.getBlockById(scriptList[i].id);
        if (block) {
            block.setFieldValue(scriptList[i].priority, 'Priority');
        }
    }
}

let gMicrophoneSelect1by3Option = [
    [["Null Device", "0"]],
    [["Null Device", "1"]],
    [["Null Device", "2"]],
    [["Null Device", "3"]]
];
//------------------------------AE-Microphone-----------------------------------
Blockly.Blocks['TriggerConditions1by3'] = {
    init: function() {
        this.microphoneName = [ "Shure:MXA910"]; 
        this.lastmicrophoneName = [ "Shure:MXA910"];   
        this.maxRangeValue = 0;
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Cruise_Mode_for_1_by_3_Layout"));
        this.appendEndRowInput().appendField(" ");

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Microphone_Select")+" : ")
            .appendField(new Blockly
            .FieldDropdown(gMicrophoneSelectOptionNew, this.onMicrophoneChange.bind(this)), "MICROPHONE_VALUE")
            .appendField(" "+window.LanguageManager.getTranslatedText("Status")+": ")
            .appendField(new Blockly.FieldImage("./images/Disable.png", 12, 12, "*", { alt: "Status", flipRtl: false }), "STATUS_ICON1");
        
        this.microphoneValue = parseInt(gMicrophoneSelectOptionNew, 10);

        this.MicSelect = this.appendEndRowInput()
            .appendField("Select main channel : ")
            .appendField(new Blockly.FieldDropdown(gMicrophoneSelectChannelOption[0]), "MICROPHONE_SELECT_VALUE")
            .appendField(" (range : ")
            .appendField("1","MICROPHONE_SELECT_START")
            .appendField("~")
            .appendField("100","MICROPHONE_SELECT_END")
            .appendField(" )");

        this.timeToCount = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Trigger_count")+" : ")
            .appendField(new Blockly.FieldNumber(1, 1, 100), "TRIGGER_COUNT")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("1", "TRIGGER_COUNT_START")
            .appendField("~")
            .appendField("100", "TRIGGER_COUNT_END")
            .appendField(" )");

        this.audioTriggerLevel = this.appendEndRowInput()
            .appendField("Audio Trigger Level : ")
            .appendField("50", "AUDIO_TRIGGER_LEVEL")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0", "AUDIO_TRIGGER_LEVEL_START")
            .appendField("~")
            .appendField("100", "AUDIO_TRIGGER_LEVEL_END")
            .appendField(" )");
            
        this.timeToTrigger = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Trigger")+" : ")
            .appendField("0.1", "TIME_TRIGGER")
            .appendField("s", "TIME_TRIGGER_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0.1"+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_START")
            .appendField("~")
            .appendField("5"+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_END")
            .appendField(" )");

        this.timeToMute = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Mute")+" : ")
            .appendField("1", "TIME_MUTE")
            .appendField(window.LanguageManager.getTranslatedText("s"), "TIME_MUTE_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("10 "+window.LanguageManager.getTranslatedText("s"), "MUTE_START")
            .appendField("~")
            .appendField("3", "MUTE_END")
            .appendField(window.LanguageManager.getTranslatedText("min")+")");

        this.MicSelect.setVisible(false);
        this.timeToTrigger.setVisible(false); 
        this.timeToMute.setVisible(false);
        this.timeToCount.setVisible(false);
        this.audioTriggerLevel.setVisible(false);
        this.inputRows = {};
        this.appendEndRowInput().appendField('Microphone position select : ');

        for(let index = 1; index <= 128; index++)
        {
            const MicPosFunc =  this.appendStatementInput('DO'+index)
            .appendField(`[ Mic ${index} trigger with camera stream ]`,'MICROPHONE_FUNC'+index);
            let visible = (index === 1);
            this.inputRows[index-1] = {MicPosFunc};
            this.setRowVisibility(index,visible);
        }
        this.setPreviousStatement(true,'TriggerConditions1by3');
        this.setNextStatement(true,'TriggerConditions1by3');
        this.setColour(230);
        this.setTooltip("Microphone Trigger Conditions");
        this.setHelpUrl("");
    },
    setRowVisibility: function(index, visible) {
        const row = this.inputRows[index-1];
        if (row) 
        {
            row.MicPosFunc.setVisible(visible);
        }
    },
    onMicrophoneChange: function(newValue) {
         const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === newValue);
         let soundTabIndex = parseInt(selectedOption[1],10)-1;
         gNowSelectSoundTabIndex = soundTabIndex;
 
         if (gMicrophoneSelectChannelOption[soundTabIndex]) 
         {
             let newOptions = gMicrophoneSelectChannelOption[soundTabIndex];
             let dropdown = this.getField("MICROPHONE_SELECT_VALUE");
             if (dropdown) 
             {
                dropdown.menuGenerator_ = newOptions;
                dropdown.setValue(newOptions[0][1]);
             }
         }
 
         if(AIBoxState.Tab[soundTabIndex])
         {
            let maxRangeValue = AIBoxState.Tab[soundTabIndex].RangeArray.length;
            let audioTriggerLevel = AIBoxState.Tab[soundTabIndex].Advance.AudioTriggerLevel;
            let backHomeTime = AIBoxState.Tab[soundTabIndex].Advance.BackToHomeTime;
            let timeToTrigger = AIBoxState.Tab[soundTabIndex].Advance.TimeToTriggerPreset;
            let deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
            
            this.maxRangeValue = maxRangeValue;
            for(let index = 1; index <= 128; index++)
            {
                this.setRowVisibility(index,false);
            }

            for(let index = 1; index <= maxRangeValue; index++)
            {
                let MicphoneFuncField = this.getField('MICROPHONE_FUNC'+index);
                MicphoneFuncField.setValue('[ Mic '+index+' trigger with camera stream ] position : '+gMicrophoneSelectChannelOption[soundTabIndex][index-1][0]);
                this.setRowVisibility(index,true);
            }

            const displayField = this.getField('MICROPHONE_SELECT_VALUE_END');
            const timeToTriggerField = this.getField('TIME_TRIGGER');
            const timeToMuteField = this.getField('TIME_MUTE');
            const timeToMuteTypeField = this.getField('TIME_MUTE_TYPE');
            const audioTriggerLevelField = this.getField('AUDIO_TRIGGER_LEVEL');
            const audioTriggerLevelStartField = this.getField('AUDIO_TRIGGER_LEVEL_START');
            const audioTriggerLevelEndField = this.getField('AUDIO_TRIGGER_LEVEL_END'); 
            const MicphoneSelectStartField = this.getField('MICROPHONE_SELECT_START');
            const MicphoneSelectEndField = this.getField('MICROPHONE_SELECT_END');

            if(audioTriggerLevelField)
            {
                switch(deviceIndex)
                {
                    case 0:case 1:case 2:case 3:case 4:
                        this.audioTriggerLevel.setVisible(false);
                        break;
                    case 5:case 6:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(-90);
                        audioTriggerLevelEndField.setValue(0);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;
                    case 7:case 8:case 9:case 10:case 11:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(120);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;

                    case 12:case 13:case 14:case 15:case 16:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(126);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;

                    case 17:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(60);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;
                }
            }
            
            switch(deviceIndex)
            {
                case 0:case 1:case 2:case 3:case 4:
                case 11:
                case 13:case 14:case 15:case 16:
                case 17:
                    MicphoneSelectStartField.setValue(1);
                    MicphoneSelectEndField.setValue(maxRangeValue);
                break;
                case 5:case 6:
                    MicphoneSelectStartField.setValue(0);
                    MicphoneSelectEndField.setValue(360);
                break;
                case 7:case 8:case 9:case 10:
                    MicphoneSelectStartField.setValue(-70);
                    MicphoneSelectEndField.setValue(70);
                break;
                case 12:
                    MicphoneSelectStartField.setValue(-180);
                    MicphoneSelectEndField.setValue(180);
                break;
            }
            if(displayField)
            {
                displayField.setValue(maxRangeValue);
            }
            if(timeToMuteField)
            {
                switch(backHomeTime)
                {
                    case 0:
                        timeToMuteField.setValue('off');
                    break;
                    case 1:
                        timeToMuteField.setValue('10');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 2:
                        timeToMuteField.setValue('20');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 3:
                        timeToMuteField.setValue('30');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 4:
                        timeToMuteField.setValue('40');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 5:
                        timeToMuteField.setValue('50');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 6:
                        timeToMuteField.setValue('1');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                    case 7:
                        timeToMuteField.setValue('2');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                    case 8:
                        timeToMuteField.setValue('3');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                }
            }
            if(timeToTriggerField)
            {
                switch(timeToTrigger)
                {
                    case 0:
                        timeToTriggerField.setValue('0.1');
                    break;
                    case 1:
                        timeToTriggerField.setValue('0.3');
                    break;
                    case 2:
                        timeToTriggerField.setValue('0.5');
                    break;
                    case 3:
                        timeToTriggerField.setValue('1');
                    break;
                    case 4:
                        timeToTriggerField.setValue('1.5');
                    break;
                    case 5:
                        timeToTriggerField.setValue('2');
                    break;
                    case 6:
                        timeToTriggerField.setValue('3');
                    break;
                    case 7:
                        timeToTriggerField.setValue('4');
                    break;
                    case 8:
                        timeToTriggerField.setValue('5');
                    break;
                }
            }

            this.MicSelect.setVisible(true);
            this.timeToTrigger.setVisible(true);
            this.timeToMute.setVisible(true);
            this.timeToCount.setVisible(true);
         }
 
         if(newValue == 99)
         {
            this.MicSelect.setVisible(false);
            this.audioTriggerLevel.setVisible(false);
            this.timeToTrigger.setVisible(false);
            this.timeToMute.setVisible(false);
            this.timeToCount.setVisible(false);
         }
    }
};

Blockly.JavaScript.forBlock['TriggerConditions1by3'] = function(block) {

    let script = {}; 
    const scriptParams = {}
    const microphone            = block.getFieldValue('MICROPHONE_VALUE');
    const microphoneMainChannel = block.getFieldValue('MICROPHONE_SELECT_VALUE');
    const timeTrigger           = block.getFieldValue('TIME_TRIGGER');
    const timeMute              = block.getFieldValue('TIME_MUTE');
    const triggerCount          = block.getFieldValue('TRIGGER_COUNT');

    const micParams = {
        microphone:             microphone,
        microphoneMainChannel:  microphoneMainChannel,
        timeTrigger:            timeTrigger,
        timeMute:               timeMute,
        triggerCount:           triggerCount
    };

    for(let index = 1; index <= this.maxRangeValue; index++)
    {
        script[index-1] = Blockly.JavaScript.statementToCode(block,'DO'+index);
        scriptParams[`script${index-1}`] = script[index-1];
    }
   
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'TriggerConditions');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SnedTriggerConditions',
        Params: {
            Microphone: micParams,
            ScriptParams:scriptParams,
            priority: priority
        }
    }) + ';\n';
};

const deviceAudioConfig = {
    'Shure_MXA910': { visible: false },
    'Shure_MXA920': { visible: false },
    'Shure_MXA920_XY': { visible: false },
    'Shure_MXA710': { visible: false },
    'Shure_MXA310': { visible: false },
    'Shure_MXCW': { visible: false },
    'Shure_P300': { visible: false },
    'Sennheiser_TCC2': { visible: true, min: -90, max: 0, defaultValue: -50 },
    'Sennheiser_TCCM': { visible: true, min: -90, max: 0, defaultValue: -50 },
    'Sennheiser_TCC2_XY': { visible: true, min: -90, max: 0, defaultValue: -50 },
    'Sennheiser_TCCM_XY': { visible: true, min: -90, max: 0, defaultValue: -50 },
    'Nureva_HDL300': { visible: true, min: 0, max: 120, defaultValue: 50 },
    'Nureva_DUAL_HDL300': { visible: true, min: 0, max: 120, defaultValue: 50 },
    'Nureva_HDL310': { visible: true, min: 0, max: 120, defaultValue: 50 },
    'Nureva_HDL410': { visible: true, min: 0, max: 120, defaultValue: 50 },
    'Nureva_HDL410_XY': { visible: true, min: 0, max: 120, defaultValue: 50 },
    'Yamaha_RMCG': { visible: true, min: 0, max: 126, defaultValue: 50 },
    'Yamaha_RMCG_XY': { visible: true, min: 0, max: 126, defaultValue: 50 },
    'Yamaha_RMW': { visible: true, min: 0, max: 126, defaultValue: 50 },
    'Yamaha_RMCR': { visible: true, min: 0, max: 126, defaultValue: 50 },
    'Yamaha_RMTT': { visible: true, min: 0, max: 126, defaultValue: 50 },
    'AudioTechnica_ATND1061': { visible: true, min: 0, max: 60, defaultValue: 30 },
    'AudioTechnica_ATND1061_XY': { visible: true, min: 0, max: 60, defaultValue: 30 }
};

const deviceChannelConfig = {
    'Shure_MXA910': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_MXA920': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_MXA920_XY': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_MXA710': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_MXA310': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_MXCW': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Shure_P300': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Sennheiser_TCC2': { rangeStart: -70, rangeEnd: 70 , channelType: 'azimuth'},
    'Sennheiser_TCCM': { rangeStart: -70, rangeEnd: 70 , channelType: 'azimuth'},
    'Sennheiser_TCC2_XY': { rangeStart: -70, rangeEnd: 70 , channelType: 'azimuth'},
    'Sennheiser_TCCM_XY': { rangeStart: -70, rangeEnd: 70 , channelType: 'azimuth'},
    'Nureva_HDL300': { rangeStart: 0, rangeEnd: 360 , channelType: 'azimuth'},
    'Nureva_DUAL_HDL300': { rangeStart: 0, rangeEnd: 360 , channelType: 'azimuth'},
    'Nureva_HDL310': { rangeStart: 0, rangeEnd: 360 , channelType: 'azimuth'},
    'Nureva_HDL410': { rangeStart: -180, rangeEnd: 180 , channelType: 'azimuth'},
    'Nureva_HDL410_XY': { rangeStart: -180, rangeEnd: 180 , channelType: 'azimuth'},
    'Yamaha_RMCG': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Yamaha_RMCG_XY': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Yamaha_RMW': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Yamaha_RMCR': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'Yamaha_RMTT': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'AudioTechnica_ATND1061': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'},
    'AudioTechnica_ATND1061_XY': { rangeStart: 1, rangeEnd: 128 , channelType: 'preset'}
};

function closeZoneMapWindow(){
    var popupWindow = document.getElementById('ZoneMap_popup_window');
    popupWindow.style.display = 'none';   

    const blocks = workspace.getAllBlocks();
    blocks.forEach(block => {
        if (block.type === 'TriggerConditions') {
            block.setFieldValue('FALSE', 'ZONE_MAP_ENABLED');
        }
    });
}

function openZoneMapWindow(block, onCloseCallback) {
    console.log('openZoneMapWindow');
    var popupWindow = document.getElementById('ZoneMap_popup_window');
    popupWindow.innerHTML = '';
    popupWindow.style.userSelect = 'none';
    popupWindow.style.WebkitUserDrag = 'none'; 
    popupWindow.draggable = false;
    
    var titleBar = document.createElement('tr');            
    var titleBarRow = document.createElement("td");
    titleBarRow.className = 'MicZonetitleBarRow';
    titleBarRow.style.userSelect = 'none';
    titleBarRow.style.WebkitUserDrag = 'none'; 
    titleBarRow.draggable = false;
    
        var cell1 = document.createElement("td");
        cell1.className = "title-bar-cell micZoneModelogo-cell";
            var logoImage = document.createElement('img');
                logoImage.id = 'logo_image';
                logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                logoImage.src = '../imagesaibox/CamConnect.png';
                logoImage.style.userSelect = 'none';
                logoImage.style.WebkitUserDrag = 'none'; 
                logoImage.draggable = false;
        cell1.appendChild(logoImage);
        
        var cell2 = document.createElement("td");
        cell2.className = "title-bar-cell title-cell";
            var zone_title = document.createElement('label');
            zone_title.className = 'Font_Arial_18_bold mic-xy-title';
            zone_title.textContent = window.LanguageManager.getTranslatedText("Zone_Map");
            zone_title.style.userSelect = 'none'; 
            zone_title.style.WebkitUserDrag = 'none';
            zone_title.draggable = false;
        cell2.appendChild(zone_title);
        
        var cell3 = document.createElement("td");
        cell3.className = "title-bar-cell close-button-cell";
            var closeButton = document.createElement('button');
            closeButton.id = 'close_ZoneMap_Popup';
            closeButton.className = 'close-popup-btn';
            closeButton.setAttribute("onclick", "closeZoneMapWindow()");
            closeButton.style.userSelect = 'none';
            closeButton.style.WebkitUserDrag = 'none'; 
            closeButton.draggable = false;
        cell3.appendChild(closeButton);
        
    titleBarRow.appendChild(cell1);
    titleBarRow.appendChild(cell2);
    titleBarRow.appendChild(cell3);
    titleBar.appendChild(titleBarRow);
    
    // Zone Map Content
    var contentRow = document.createElement('tr');
    var contentCell = document.createElement('td');
    contentCell.style.padding = '20px';
    
        // Zone Layout Setting
        var layoutSection = document.createElement('div');
        layoutSection.style.marginBottom = '15px';
            var layoutLabel = document.createElement('label');
            layoutLabel.className = 'Font_Arial_14_bold';
            layoutLabel.textContent = window.LanguageManager.getTranslatedText("Zone_Layout") + ': ';
            layoutLabel.style.display = 'inline-block';
            layoutLabel.style.width = '150px';
            
            var layoutSelect = document.createElement('select');
            layoutSelect.id = 'zoneLayoutSelect';
            layoutSelect.style.padding = '5px';
            layoutSelect.style.width = '200px';
                var gridOption = document.createElement('option');
                gridOption.value = 'grid';
                gridOption.textContent = 'Grid Layout';
                layoutSelect.appendChild(gridOption);
                
                var customOption = document.createElement('option');
                customOption.value = 'custom';
                customOption.textContent = 'Custom Layout';
                layoutSelect.appendChild(customOption);
                
        layoutSection.appendChild(layoutLabel);
        layoutSection.appendChild(layoutSelect);
        
        // Number of Zones Setting
        var zoneCountSection = document.createElement('div');
        zoneCountSection.style.marginBottom = '15px';
            var zoneCountLabel = document.createElement('label');
            zoneCountLabel.className = 'Font_Arial_14_bold';
            zoneCountLabel.textContent = window.LanguageManager.getTranslatedText("Number_of_Zones") + ': ';
            zoneCountLabel.style.display = 'inline-block';
            zoneCountLabel.style.width = '150px';
            
            var zoneCountInput = document.createElement('input');
            zoneCountInput.id = 'zoneCountInput';
            zoneCountInput.type = 'number';
            zoneCountInput.min = '1';
            zoneCountInput.max = '16';
            zoneCountInput.value = '4';
            zoneCountInput.style.padding = '5px';
            zoneCountInput.style.width = '80px';
            
        zoneCountSection.appendChild(zoneCountLabel);
        zoneCountSection.appendChild(zoneCountInput);
        
        // Zone Detection Sensitivity Setting
        var sensitivitySection = document.createElement('div');
        sensitivitySection.style.marginBottom = '15px';
            var sensitivityLabel = document.createElement('label');
            sensitivityLabel.className = 'Font_Arial_14_bold';
            sensitivityLabel.textContent = window.LanguageManager.getTranslatedText("Zone_Detection_Sensitivity") + ': ';
            sensitivityLabel.style.display = 'inline-block';
            sensitivityLabel.style.width = '150px';
            
            var sensitivityRange = document.createElement('input');
            sensitivityRange.id = 'sensitivityRange';
            sensitivityRange.type = 'range';
            sensitivityRange.min = '1';
            sensitivityRange.max = '10';
            sensitivityRange.value = '5';
            sensitivityRange.style.width = '150px';
            
            var sensitivityValue = document.createElement('span');
            sensitivityValue.id = 'sensitivityValue';
            sensitivityValue.className = 'Font_Arial_14_bold';
            sensitivityValue.textContent = '5';
            sensitivityValue.style.marginLeft = '10px';
            
            sensitivityRange.addEventListener('input', function() {
                sensitivityValue.textContent = this.value;
            });
            
        sensitivitySection.appendChild(sensitivityLabel);
        sensitivitySection.appendChild(sensitivityRange);
        sensitivitySection.appendChild(sensitivityValue);
        
        // Auto Switch Zones Setting
        var autoSwitchSection = document.createElement('div');
        autoSwitchSection.style.marginBottom = '20px';
            var autoSwitchLabel = document.createElement('label');
            autoSwitchLabel.className = 'Font_Arial_14_bold';
            autoSwitchLabel.textContent = window.LanguageManager.getTranslatedText("Auto_Switch_Zones") + ': ';
            autoSwitchLabel.style.display = 'inline-block';
            autoSwitchLabel.style.width = '150px';
            
            var autoSwitchCheckbox = document.createElement('input');
            autoSwitchCheckbox.id = 'autoSwitchCheckbox';
            autoSwitchCheckbox.type = 'checkbox';
            
        autoSwitchSection.appendChild(autoSwitchLabel);
        autoSwitchSection.appendChild(autoSwitchCheckbox);
        
        // Action Buttons
        var buttonSection = document.createElement('div');
        buttonSection.style.textAlign = 'center';
        buttonSection.style.borderTop = '1px solid #ddd';
        buttonSection.style.paddingTop = '15px';
        
            var saveButton = document.createElement('button');
            saveButton.className = 'Btn_style';
            saveButton.textContent = window.LanguageManager.getTranslatedText("Save");
            saveButton.style.margin = '0 10px';
            saveButton.addEventListener('click', function() {
                console.log('Zone Map Save clicked');
                if (onCloseCallback) onCloseCallback();
                closeZoneMapWindow();
            });
            
            var cancelButton = document.createElement('button');
            cancelButton.className = 'Btn_style';
            cancelButton.textContent = window.LanguageManager.getTranslatedText("Cancel");
            cancelButton.style.margin = '0 10px';
            cancelButton.style.backgroundColor = '#6c757d';
            cancelButton.addEventListener('click', function() {
                if (onCloseCallback) onCloseCallback();
                closeZoneMapWindow();
            });
            
        buttonSection.appendChild(saveButton);
        buttonSection.appendChild(cancelButton);
        
    contentCell.appendChild(layoutSection);
    contentCell.appendChild(zoneCountSection);
    contentCell.appendChild(sensitivitySection);
    contentCell.appendChild(autoSwitchSection);
    contentCell.appendChild(buttonSection);
    contentRow.appendChild(contentCell);
    
    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(contentRow);
    popupWindow.style.display = 'block';
}

function closeCameraWindow(){
    var popupWindow = document.getElementById('CameraSettings_popup_window');
    popupWindow.style.display = 'none';   

    const blocks = workspace.getAllBlocks();
    blocks.forEach(block => {
        if (block.type === 'TriggerConditions') {
            block.setFieldValue('FALSE', 'CAMERA_ENABLED');
        }
    });
}

function openCameraWindow(block, onCloseCallback) {
    console.log('openCameraWindow');
    var popupWindow = document.getElementById('CameraSettings_popup_window');
    popupWindow.innerHTML = '';
    popupWindow.style.userSelect = 'none';
    popupWindow.style.WebkitUserDrag = 'none'; 
    popupWindow.draggable = false;
    
    var titleBar = document.createElement('tr');            
    var titleBarRow = document.createElement("td");
    titleBarRow.className = 'MicZonetitleBarRow';
    titleBarRow.style.userSelect = 'none';
    titleBarRow.style.WebkitUserDrag = 'none'; 
    titleBarRow.draggable = false;
    
        var cell1 = document.createElement("td");
        cell1.className = "title-bar-cell micZoneModelogo-cell";
            var logoImage = document.createElement('img');
                logoImage.id = 'logo_image';
                logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                logoImage.src = '../imagesaibox/CamConnect.png';
                logoImage.style.userSelect = 'none';
                logoImage.style.WebkitUserDrag = 'none'; 
                logoImage.draggable = false;
        cell1.appendChild(logoImage);
        
        var cell2 = document.createElement("td");
        cell2.className = "title-bar-cell title-cell";
            var camera_title = document.createElement('label');
            camera_title.className = 'Font_Arial_18_bold mic-xy-title';
            camera_title.textContent = window.LanguageManager.getTranslatedText("Camera_Settings");
            camera_title.style.userSelect = 'none'; 
            camera_title.style.WebkitUserDrag = 'none';
            camera_title.draggable = false;
        cell2.appendChild(camera_title);
        
        var cell3 = document.createElement("td");
        cell3.className = "title-bar-cell close-button-cell";
            var closeButton = document.createElement('button');
            closeButton.id = 'close_Camera_Popup';
            closeButton.className = 'close-popup-btn';
            closeButton.setAttribute("onclick", "closeCameraWindow()");
            closeButton.style.userSelect = 'none';
            closeButton.style.WebkitUserDrag = 'none'; 
            closeButton.draggable = false;
        cell3.appendChild(closeButton);
        
    titleBarRow.appendChild(cell1);
    titleBarRow.appendChild(cell2);
    titleBarRow.appendChild(cell3);
    titleBar.appendChild(titleBarRow);
    
    // Camera Settings Content
    var contentRow = document.createElement('tr');
    var contentCell = document.createElement('td');
    contentCell.style.padding = '20px';
    
        // Camera Resolution Setting
        var resolutionSection = document.createElement('div');
        resolutionSection.style.marginBottom = '15px';
            var resolutionLabel = document.createElement('label');
            resolutionLabel.className = 'Font_Arial_14_bold';
            resolutionLabel.textContent = window.LanguageManager.getTranslatedText("Camera_Resolution") + ': ';
            resolutionLabel.style.display = 'inline-block';
            resolutionLabel.style.width = '150px';
            
            var resolutionSelect = document.createElement('select');
            resolutionSelect.id = 'resolutionSelect';
            resolutionSelect.style.padding = '5px';
            resolutionSelect.style.width = '200px';
                var res720p = document.createElement('option');
                res720p.value = '720p';
                res720p.textContent = '720p (1280x720)';
                resolutionSelect.appendChild(res720p);
                
                var res1080p = document.createElement('option');
                res1080p.value = '1080p';
                res1080p.textContent = '1080p (1920x1080)';
                res1080p.selected = true;
                resolutionSelect.appendChild(res1080p);
                
                var res4K = document.createElement('option');
                res4K.value = '4K';
                res4K.textContent = '4K (3840x2160)';
                resolutionSelect.appendChild(res4K);
                
        resolutionSection.appendChild(resolutionLabel);
        resolutionSection.appendChild(resolutionSelect);
        
        // Frame Rate Setting
        var frameRateSection = document.createElement('div');
        frameRateSection.style.marginBottom = '15px';
            var frameRateLabel = document.createElement('label');
            frameRateLabel.className = 'Font_Arial_14_bold';
            frameRateLabel.textContent = window.LanguageManager.getTranslatedText("Frame_Rate") + ': ';
            frameRateLabel.style.display = 'inline-block';
            frameRateLabel.style.width = '150px';
            
            var frameRateSelect = document.createElement('select');
            frameRateSelect.id = 'frameRateSelect';
            frameRateSelect.style.padding = '5px';
            frameRateSelect.style.width = '200px';
                var fps15 = document.createElement('option');
                fps15.value = '15';
                fps15.textContent = '15 FPS';
                frameRateSelect.appendChild(fps15);
                
                var fps30 = document.createElement('option');
                fps30.value = '30';
                fps30.textContent = '30 FPS';
                fps30.selected = true;
                frameRateSelect.appendChild(fps30);
                
                var fps60 = document.createElement('option');
                fps60.value = '60';
                fps60.textContent = '60 FPS';
                frameRateSelect.appendChild(fps60);
                
        frameRateSection.appendChild(frameRateLabel);
        frameRateSection.appendChild(frameRateSelect);
        
        // Auto Focus Setting
        var autoFocusSection = document.createElement('div');
        autoFocusSection.style.marginBottom = '15px';
            var autoFocusLabel = document.createElement('label');
            autoFocusLabel.className = 'Font_Arial_14_bold';
            autoFocusLabel.textContent = window.LanguageManager.getTranslatedText("Auto_Focus") + ': ';
            autoFocusLabel.style.display = 'inline-block';
            autoFocusLabel.style.width = '150px';
            
            var autoFocusCheckbox = document.createElement('input');
            autoFocusCheckbox.id = 'autoFocusCheckbox';
            autoFocusCheckbox.type = 'checkbox';
            autoFocusCheckbox.checked = true;
            
        autoFocusSection.appendChild(autoFocusLabel);
        autoFocusSection.appendChild(autoFocusCheckbox);
        
        // Motion Detection Setting
        var motionDetectionSection = document.createElement('div');
        motionDetectionSection.style.marginBottom = '15px';
            var motionDetectionLabel = document.createElement('label');
            motionDetectionLabel.className = 'Font_Arial_14_bold';
            motionDetectionLabel.textContent = window.LanguageManager.getTranslatedText("Motion_Detection") + ': ';
            motionDetectionLabel.style.display = 'inline-block';
            motionDetectionLabel.style.width = '150px';
            
            var motionDetectionCheckbox = document.createElement('input');
            motionDetectionCheckbox.id = 'motionDetectionCheckbox';
            motionDetectionCheckbox.type = 'checkbox';
            
        motionDetectionSection.appendChild(motionDetectionLabel);
        motionDetectionSection.appendChild(motionDetectionCheckbox);
        
        // Recording Quality Setting
        var recordingQualitySection = document.createElement('div');
        recordingQualitySection.style.marginBottom = '15px';
            var recordingQualityLabel = document.createElement('label');
            recordingQualityLabel.className = 'Font_Arial_14_bold';
            recordingQualityLabel.textContent = window.LanguageManager.getTranslatedText("Recording_Quality") + ': ';
            recordingQualityLabel.style.display = 'inline-block';
            recordingQualityLabel.style.width = '150px';
            
            var recordingQualitySelect = document.createElement('select');
            recordingQualitySelect.id = 'recordingQualitySelect';
            recordingQualitySelect.style.padding = '5px';
            recordingQualitySelect.style.width = '200px';
                var qualityLow = document.createElement('option');
                qualityLow.value = 'low';
                qualityLow.textContent = 'Low';
                recordingQualitySelect.appendChild(qualityLow);
                
                var qualityMedium = document.createElement('option');
                qualityMedium.value = 'medium';
                qualityMedium.textContent = 'Medium';
                qualityMedium.selected = true;
                recordingQualitySelect.appendChild(qualityMedium);
                
                var qualityHigh = document.createElement('option');
                qualityHigh.value = 'high';
                qualityHigh.textContent = 'High';
                recordingQualitySelect.appendChild(qualityHigh);
                
        recordingQualitySection.appendChild(recordingQualityLabel);
        recordingQualitySection.appendChild(recordingQualitySelect);
        
        // Brightness Setting
        var brightnessSection = document.createElement('div');
        brightnessSection.style.marginBottom = '20px';
            var brightnessLabel = document.createElement('label');
            brightnessLabel.className = 'Font_Arial_14_bold';
            brightnessLabel.textContent = window.LanguageManager.getTranslatedText("Brightness") + ': ';
            brightnessLabel.style.display = 'inline-block';
            brightnessLabel.style.width = '150px';
            
            var brightnessRange = document.createElement('input');
            brightnessRange.id = 'brightnessRange';
            brightnessRange.type = 'range';
            brightnessRange.min = '0';
            brightnessRange.max = '100';
            brightnessRange.value = '50';
            brightnessRange.style.width = '150px';
            
            var brightnessValue = document.createElement('span');
            brightnessValue.id = 'brightnessValue';
            brightnessValue.className = 'Font_Arial_14_bold';
            brightnessValue.textContent = '50';
            brightnessValue.style.marginLeft = '10px';
            
            brightnessRange.addEventListener('input', function() {
                brightnessValue.textContent = this.value;
            });
            
        brightnessSection.appendChild(brightnessLabel);
        brightnessSection.appendChild(brightnessRange);
        brightnessSection.appendChild(brightnessValue);
        
        // Action Buttons
        var buttonSection = document.createElement('div');
        buttonSection.style.textAlign = 'center';
        buttonSection.style.borderTop = '1px solid #ddd';
        buttonSection.style.paddingTop = '15px';
        
            var saveButton = document.createElement('button');
            saveButton.className = 'Btn_style';
            saveButton.textContent = window.LanguageManager.getTranslatedText("Save");
            saveButton.style.margin = '0 10px';
            saveButton.addEventListener('click', function() {
                console.log('Camera Settings Save clicked');
                if (onCloseCallback) onCloseCallback();
                closeCameraWindow();
            });
            
            var cancelButton = document.createElement('button');
            cancelButton.className = 'Btn_style';
            cancelButton.textContent = window.LanguageManager.getTranslatedText("Cancel");
            cancelButton.style.margin = '0 10px';
            cancelButton.style.backgroundColor = '#6c757d';
            cancelButton.addEventListener('click', function() {
                if (onCloseCallback) onCloseCallback();
                closeCameraWindow();
            });
            
        buttonSection.appendChild(saveButton);
        buttonSection.appendChild(cancelButton);
        
    contentCell.appendChild(resolutionSection);
    contentCell.appendChild(frameRateSection);
    contentCell.appendChild(autoFocusSection);
    contentCell.appendChild(motionDetectionSection);
    contentCell.appendChild(recordingQualitySection);
    contentCell.appendChild(brightnessSection);
    contentCell.appendChild(buttonSection);
    contentRow.appendChild(contentCell);
    
    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(contentRow);
    popupWindow.style.display = 'block';
}


function closeRemoteMicWindow(){
    var popupWindow =  document.getElementById('ReferenceAudioInput_popup_window');
    popupWindow.style.display = 'none';   

    const blocks = workspace.getAllBlocks();
    blocks.forEach(block => {
        if (block.type === 'TriggerConditions') {
            block.setFieldValue('FALSE', 'REMOTE_MIC_ENABLED');
        }
    });
}

function openRemoteMicWindow(block, onCloseCallback) {
    console.log('openRemoteMicWindow');
    var popupWindow = document.getElementById('ReferenceAudioInput_popup_window');
    popupWindow.innerHTML = '';
    popupWindow.style.userSelect = 'none';
    popupWindow.style.WebkitUserDrag = 'none'; 
    popupWindow.draggable = false;
    popupWindow.style.position = 'fixed';
    popupWindow.style.top = '50%';
    popupWindow.style.left = '65%';
    popupWindow.style.transform = 'translate(-50%, -50%)';
    popupWindow.style.zIndex = '2001';
    
    var titleBar = document.createElement('tr');            
    var titleBarRow = document.createElement("td");
    titleBarRow.className = 'RefAudiotitleBarRow';
    titleBarRow.style.userSelect = 'none';
    titleBarRow.style.WebkitUserDrag = 'none'; 
    titleBarRow.draggable = false;
    titleBarRow.style.cursor = 'move';
        var cell1 = document.createElement("td");
        cell1.className = "title-bar-cell micZoneModelogo-cell";
            var logoImage = document.createElement('img');
                logoImage.id = 'logo_image';
                logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                logoImage.src = '../imagesaibox/CamConnect.png';
                logoImage.style.userSelect = 'none';
                logoImage.style.WebkitUserDrag = 'none'; 
                logoImage.draggable = false;
        cell1.appendChild(logoImage);
        
        var cell2 = document.createElement("td");
        cell2.className = "title-bar-cell title-cell";
            var mic_xy_title = document.createElement('label');
            mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
            mic_xy_title.textContent = window.LanguageManager.getTranslatedText("Label_Reference_AudioInput");
            mic_xy_title.style.userSelect = 'none'; 
            mic_xy_title.style.WebkitUserDrag = 'none';
            mic_xy_title.draggable = false;
        cell2.appendChild(mic_xy_title);
        
        var cell3 = document.createElement("td");
        cell3.className = "title-bar-cell close-button-cell";
            var closeButton = document.createElement('button');
            closeButton.id = 'close_Ref_Popup';
            closeButton.className = 'close-popup-btn';
            closeButton.setAttribute("onclick", "closeRemoteMicWindow()");
            closeButton.style.userSelect = 'none';
            closeButton.style.WebkitUserDrag = 'none'; 
            closeButton.draggable = false;
        cell3.appendChild(closeButton);
        
    titleBarRow.appendChild(cell1);
    titleBarRow.appendChild(cell2);
    titleBarRow.appendChild(cell3);
    titleBar.appendChild(titleBarRow);

    let isDragging = false;
    let currentX;
    let currentY;
    let initialX;
    let initialY;
    let xOffset = 0;
    let yOffset = 0;

    titleBarRow.addEventListener('mousedown', function(e) {
        if (e.target === titleBarRow || titleBarRow.contains(e.target)) {
            if (e.target.className && e.target.className.includes('close-popup-btn')) {
                return;
            }
            
            isDragging = true;
            
            if (e.type === "touchstart") {
                initialX = e.touches[0].clientX - xOffset;
                initialY = e.touches[0].clientY - yOffset;
            } else {
                initialX = e.clientX - xOffset;
                initialY = e.clientY - yOffset;
            }
            
            if (e.target === titleBarRow || titleBarRow.contains(e.target)) {
                e.preventDefault();
            }
        }
    });

    document.addEventListener('mousemove', function(e) {
        if (isDragging) {
            e.preventDefault();
            
            if (e.type === "touchmove") {
                currentX = e.touches[0].clientX - initialX;
                currentY = e.touches[0].clientY - initialY;
            } else {
                currentX = e.clientX - initialX;
                currentY = e.clientY - initialY;
            }
            
            xOffset = currentX;
            yOffset = currentY;
            
            // šÏ¥Î translate3d šÓŽ£°ª©Ê¯à
            popupWindow.style.transform = `translate(calc(-50% + ${currentX}px), calc(-50% + ${currentY}px))`;
        }
    });

    document.addEventListener('mouseup', function(e) {
        initialX = currentX;
        initialY = currentY;
        isDragging = false;
    });

    titleBarRow.addEventListener('touchstart', function(e) {
        if (e.target === titleBarRow || titleBarRow.contains(e.target)) {
            if (e.target.className && e.target.className.includes('close-popup-btn')) {
                return;
            }
            
            isDragging = true;
            initialX = e.touches[0].clientX - xOffset;
            initialY = e.touches[0].clientY - yOffset;
            e.preventDefault();
        }
    });
    
    document.addEventListener('touchmove', function(e) {
        if (isDragging) {
            e.preventDefault();
            currentX = e.touches[0].clientX - initialX;
            currentY = e.touches[0].clientY - initialY;
            xOffset = currentX;
            yOffset = currentY;
            popupWindow.style.transform = `translate(calc(-50% + ${currentX}px), calc(-50% + ${currentY}px))`;
        }
    });
    
    document.addEventListener('touchend', function(e) {
        initialX = currentX;
        initialY = currentY;
        isDragging = false;
    });
        
    popupWindow.appendChild(titleBar);
    // popupWindow.appendChild(contentRow);
    popupWindow.style.display = 'block';
}

function getZoneMapSettings(block) {
 	console.log('getZoneMapSettings');
}

function saveZoneMapSettings(block, settings) {
 	console.log('saveZoneMapSettings');
}

function getCameraSettings(block) {
console.log('getCameraSettings');
}

function saveCameraSettings(block, settings) {
	console.log('saveCameraSettings');
}

function getRemoteMicSettings(block) {
	console.log('getRemoteMicSettings');
}

function saveRemoteMicSettings(block, settings) {
	console.log('saveRemoteMicSettings');
}

Blockly.Blocks['ConversationRule'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        
        this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Position_Index") + " : ")
            .appendField(new Blockly.FieldNumber(1, 1, 128), "POS_INDEX")
            .appendField(" (" + window.LanguageManager.getTranslatedText("range") + ": 1 ~ 128)");

        this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Trigger")+" : ")
            .appendField(new Blockly.FieldNumber(0.1, 0.1, 100, 0.1), "ENTER_TIME")
            .appendField(window.LanguageManager.getTranslatedText("s"))
            .appendField(" / ")
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Mute")+" : ")
            .appendField(new Blockly.FieldNumber(0.1, 0.1, 10, 0.1), "EXIT_TIME")
            .appendField(window.LanguageManager.getTranslatedText("s"))
            .appendField(" (" + window.LanguageManager.getTranslatedText("range") + ": 0.1 ~ 10 " + window.LanguageManager.getTranslatedText("s") + ")");

        this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Enter_Switch_Count") + " : ")
            .appendField(new Blockly.FieldNumber(1, 1, 100), "ENTER_COUNT")
            .appendField(" / ")
            .appendField(window.LanguageManager.getTranslatedText("Exit_Switch_Count") + " : ")
            .appendField(new Blockly.FieldNumber(1, 1, 100), "EXIT_COUNT")
            .appendField(" (" + window.LanguageManager.getTranslatedText("range") + ": 1 ~ 100)");

        this.setPreviousStatement(true, 'rule_connection');
        this.setNextStatement(true, 'rule_connection');
        this.setColour(180);
        this.setTooltip("Conversation Rule for specific position - can be stacked for multiple positions");
        
    }
};

Blockly.JavaScript.forBlock['ConversationRule'] = function(block) {
    const posIndex = parseInt(block.getFieldValue('POS_INDEX'), 10);
    const enterTime = parseFloat(block.getFieldValue('ENTER_TIME'));
    const exitTime = parseFloat(block.getFieldValue('EXIT_TIME'));
    const enterCount = parseInt(block.getFieldValue('ENTER_COUNT'), 10);
    const exitCount = parseInt(block.getFieldValue('EXIT_COUNT'), 10);
    const uniqueId = block.getFieldValue('UNIQUE_ID');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'ConversationRule',
        Params: {
            posIndex: posIndex,
            enterTime: enterTime,
            exitTime: exitTime,
            enterCount: enterCount,
            exitCount: exitCount
        }
    }) + ';\n';
};

Blockly.Blocks['TriggerConditions'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);

        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Conversation_Mode_for_1_by_2_Layout"));
        this.appendEndRowInput().appendField(" ");

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Microphone_Select") + " : ")
            .appendField(new Blockly.FieldDropdown(gMicrophoneSelectOptionNew, this.onMicrophoneChange.bind(this)), "MICROPHONE_VALUE");

        this.micSelect = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Select_Microphone_Channel")+" ("+window.LanguageManager.getTranslatedText("range")+"): ")
            .appendField("1", "MICROPHONE_SELECT_START")
            .appendField("~")
            .appendField("100", "MICROPHONE_SELECT_END");

        this.timeToCount = this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Trigger_count")+" : ")
            .appendField(new Blockly.FieldNumber(1, 1, 100), "TRIGGER_COUNT")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("1", "TRIGGER_COUNT_START")
            .appendField("~")
            .appendField("100", "TRIGGER_COUNT_END")
            .appendField(" )");

        const audioTriggerLevelField = new Blockly.FieldNumber(50, -90, 126, 1);
    
        this.audioTriggerLevel = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Audio_Trigger_Level")+" : ")
            .appendField(audioTriggerLevelField, "AUDIO_TRIGGER_LEVEL")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField(new Blockly.FieldLabelSerializable("0"), "AUDIO_TRIGGER_LEVEL_START")
            .appendField("~")
            .appendField(new Blockly.FieldLabelSerializable("126"), "AUDIO_TRIGGER_LEVEL_END")
            .appendField(" )");

        audioTriggerLevelField.setValidator(this.validateAudioTriggerLevel.bind(this));

        this.timeToTrigger = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Trigger")+" : ")
            .appendField(new Blockly.FieldNumber(0.1, 0.1, 100.0, 0.1), "TIME_TRIGGER")
            .appendField(window.LanguageManager.getTranslatedText("s"), "TIME_TRIGGER_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0.1 "+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_START")
            .appendField("~")
            .appendField("100 "+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_END")
            .appendField(" )");

        this.timeToMute = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Mute")+" : ")
            .appendField(new Blockly.FieldNumber(0.1, 0.1, 180.0 ,0.1), "TIME_MUTE")
            .appendField(window.LanguageManager.getTranslatedText("s"), "TIME_MUTE_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0.1 "+window.LanguageManager.getTranslatedText("s"), "MUTE_START")
            .appendField("~")
            .appendField("3", "MUTE_END")
            .appendField(" "+window.LanguageManager.getTranslatedText("min")+")");


        // this.controlSwitches = this.appendEndRowInput()
        //     .appendField( "[ "+window.LanguageManager.getTranslatedText("Control_Panel") + " ]");

        // this.zoneMapButton = this.appendEndRowInput()
        //     .appendField(window.LanguageManager.getTranslatedText("Zone_Map") + " : ")
        //     .appendField(new Blockly.FieldCheckbox('FALSE'), "ZONE_MAP_ENABLED")
        //     .appendField( " / " + window.LanguageManager.getTranslatedText("Camera_Mapping") + " : ")
        //     .appendField(new Blockly.FieldCheckbox('FALSE'), "CAMERA_ENABLED")
        //     .appendField( " / " + window.LanguageManager.getTranslatedText("Label_Reference_AudioInput") + " : ")
        //     .appendField(new Blockly.FieldCheckbox('FALSE'), "REMOTE_MIC_ENABLED");
        
            
        this.allMicOffStream  = this.appendStatementInput("DO")
                                    .appendField("[ "+window.LanguageManager.getTranslatedText("All_Mic_off_Stream")+" ]")
                                    .setCheck("script_connection");

        // this.ruleConnection = this.appendStatementInput("RULE")
        //                           .appendField("[ "+window.LanguageManager.getTranslatedText("Conversation_Rules")+" ]")
        //                           .setCheck("rule_connection");

        this.setPreviousStatement(true, 'script_connection');
        this.setNextStatement(true, 'TriggerConditions');
        this.setColour(230);
        this.setTooltip("Microphone Trigger Conditions");
        this.setHelpUrl("");

        setTimeout(() => {
            this.initializeAudioTriggerLevel();
            this.initializeMicrophoneSelectRange();
        }, 20);

        // this.setOnChange(function(changeEvent) {
        //     if (changeEvent.type === Blockly.Events.BLOCK_CHANGE && 
        //         changeEvent.element === 'field') {
                
        //         const block = workspace.getBlockById(changeEvent.blockId);
        //         if (block && block.type === 'TriggerConditions') {
        //             if (changeEvent.newValue === 'TRUE') {
        //                 switch (changeEvent.name) {
        //                     case 'ZONE_MAP_ENABLED':
        //                         openZoneMapWindow(block, () => {
        //                             block.setFieldValue('FALSE', 'ZONE_MAP_ENABLED');
        //                         });
        //                         break;
        //                     case 'CAMERA_ENABLED':
        //                         openCameraWindow(block, () => {
        //                             block.setFieldValue('FALSE', 'CAMERA_ENABLED');
        //                         });
        //                         break;
        //                     case 'REMOTE_MIC_ENABLED':
        //                         openRemoteMicWindow(block, () => {
        //                             block.setFieldValue('FALSE', 'REMOTE_MIC_ENABLED');
        //                         });
        //                         break;
        //                 }
        //             }
        //             else if (changeEvent.newValue === 'FALSE') {
        //                 switch (changeEvent.name) {
        //                     case 'ZONE_MAP_ENABLED':
        //                         closeZoneMapWindow();
        //                         break;
        //                     case 'CAMERA_ENABLED':
        //                         closeCameraWindow();
        //                         break;
        //                     case 'REMOTE_MIC_ENABLED':
        //                         closeRemoteMicWindow();
        //                         break;
        //                 }
        //             }
        //         }
        //     }
        // });
        
    },
    initializeMicrophoneSelectRange: function() {
        const microphoneValue = this.getFieldValue('MICROPHONE_VALUE');
        if (!microphoneValue || microphoneValue == 99) {
            return;
        }
    
        const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === microphoneValue);
        if (!selectedOption) {
            return;
        }
    
        const soundTabIndex = parseInt(selectedOption[1], 10) - 1;
        if (!AIBoxState.Tab[soundTabIndex]) {
            return;
        }
    
        const deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
        this.updateMicrophoneSelectRange(deviceIndex, soundTabIndex);
    },
    initializeAudioTriggerLevel: function() {
        const microphoneValue = this.getFieldValue('MICROPHONE_VALUE');
        if (!microphoneValue) {
            console.log('No microphone value found during initialization');
            return;
        }

        const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === microphoneValue);
        if (!selectedOption) {
            console.log('Selected microphone option not found during initialization:', microphoneValue);
            return;
        }

        const soundTabIndex = parseInt(selectedOption[1], 10) - 1;
        if (!AIBoxState.Tab[soundTabIndex]) {
            console.log('Sound tab not found during initialization:', soundTabIndex);
            return;
        }

        const deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
        const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === deviceIndex);
        const config = deviceAudioConfig[deviceName] || { visible: false };

        if (AIBoxState.Tab[soundTabIndex]) 
        {
            let deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
            
            const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === deviceIndex);
            const config = deviceAudioConfig[deviceName] || { visible: false };
            this.updateAudioTriggerLevelDisplay(config, soundTabIndex);

            this.micSelect.setVisible(true);
            this.timeToTrigger.setVisible(true);
            this.timeToMute.setVisible(true);
            this.timeToCount.setVisible(true);
            this.allMicOffStream.setVisible(true);
            // this.ruleConnection.setVisible(true);
        }

        if (microphoneValue == 99) 
        {
            this.micSelect.setVisible(false);
            this.audioTriggerLevel.setVisible(false);
            this.timeToTrigger.setVisible(false);
            this.timeToMute.setVisible(false);
            this.timeToCount.setVisible(false);
            this.allMicOffStream.setVisible(false);
            // this.ruleConnection.setVisible(false);
        }

        this.updateAudioTriggerLevelDisplay(config, soundTabIndex);
    },
    updateAudioTriggerLevelDisplay: function(config, soundTabIndex) {
        const audioTriggerLevelField = this.getField('AUDIO_TRIGGER_LEVEL');
        const audioTriggerLevelStartField = this.getField('AUDIO_TRIGGER_LEVEL_START');
        const audioTriggerLevelEndField = this.getField('AUDIO_TRIGGER_LEVEL_END');

        if (!audioTriggerLevelField || !audioTriggerLevelStartField || !audioTriggerLevelEndField) 
        {
            // console.warn('Audio trigger level fields not found');
            return;
        }

        if (config.visible) {
            this.audioTriggerLevel.setVisible(true);
            audioTriggerLevelStartField.setValue(config.min.toString());
            audioTriggerLevelEndField.setValue(config.max.toString());
            audioTriggerLevelField.setConstraints(config.min, config.max);

            let currentValue = config.defaultValue;
            if (soundTabIndex !== undefined && AIBoxState.Tab[soundTabIndex]) {
                currentValue = AIBoxState.Tab[soundTabIndex].Advance.AudioTriggerLevel || config.defaultValue;
            }
            let validatedValue = this.validateValueInRange(currentValue, config);
            audioTriggerLevelField.setValue(validatedValue);
        } else {
            this.audioTriggerLevel.setVisible(false);
        }
    },
    updateMicrophoneSelectRange: function(deviceIndex, soundTabIndex) {
        const micSelectStartField = this.getField('MICROPHONE_SELECT_START');
        const micSelectEndField = this.getField('MICROPHONE_SELECT_END');
        
        if (!micSelectStartField || !micSelectEndField) {
            return;
        }
        const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === deviceIndex);
        const channelConfig = deviceChannelConfig[deviceName];
        
        let startValue, endValue;
        
        if (channelConfig) {
            if (channelConfig.channelType === 'preset') {
                const maxRangeValue = AIBoxState.Tab[soundTabIndex] ? AIBoxState.Tab[soundTabIndex].RangeArray.length : channelConfig.rangeEnd;
                startValue = channelConfig.rangeStart.toString();
                endValue = maxRangeValue.toString();
            } else if (channelConfig.channelType === 'azimuth') {
                startValue = channelConfig.rangeStart.toString();
                endValue = channelConfig.rangeEnd.toString();
            } else {
                startValue = channelConfig.rangeStart.toString();
                endValue = channelConfig.rangeEnd.toString();
            }
        } else {
            startValue = "1";
            endValue = "100";
        }
        
        micSelectStartField.setValue(startValue);
        micSelectEndField.setValue(endValue);
    },

    onMicrophoneChange: function(newValue) {
        const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === newValue);
        if (!selectedOption) {
            console.warn('Selected microphone option not found:', newValue);
            return;
        }

        let soundTabIndex = parseInt(selectedOption[1], 10) - 1;
        gNowSelectSoundTabIndex = soundTabIndex;

        if (AIBoxState.Tab[soundTabIndex]) {
            let maxRangeValue = AIBoxState.Tab[soundTabIndex].RangeArray.length;
            let audioTriggerLevel = AIBoxState.Tab[soundTabIndex].Advance.AudioTriggerLevel;
            let backHomeTime = AIBoxState.Tab[soundTabIndex].Advance.BackToHomeTime;
            let timeToTrigger = AIBoxState.Tab[soundTabIndex].Advance.TimeToTriggerPreset;
            let deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;

            const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === deviceIndex);
            const config = deviceAudioConfig[deviceName] || { visible: false };
            this.updateAudioTriggerLevelDisplay(config, soundTabIndex);
            this.micSelect.setVisible(true);
            this.timeToTrigger.setVisible(true);
            this.timeToMute.setVisible(true);
            this.timeToCount.setVisible(true);
            this.allMicOffStream.setVisible(true);
            // this.ruleConnection.setVisible(true);
        }
        if (newValue == 99) {
            this.micSelect.setVisible(false);
            this.audioTriggerLevel.setVisible(false);
            this.timeToTrigger.setVisible(false);
            this.timeToMute.setVisible(false);
            this.timeToCount.setVisible(false);
            this.allMicOffStream.setVisible(false);
            // this.ruleConnection.setVisible(false);
        }
    },

    validateAudioTriggerLevel: function(newValue) {
        const config = this.getCurrentDeviceConfig();
        if (!config || !config.visible) {
            return newValue;
        }
        return this.validateValueInRange(newValue, config);
    },

    validateValueInRange: function(value, config) {
        let numValue = parseFloat(value);
        
        if (isNaN(numValue)) {
            return config.defaultValue;
        }
        
        if (numValue < config.min) {
            return config.min;
        } else if (numValue > config.max) {
            return config.max;
        }
        
        return numValue;
    },

    getCurrentDeviceConfig: function() {
        try {
            const microphoneValue = this.getFieldValue('MICROPHONE_VALUE');
            if (!microphoneValue) return { visible: false };
            
            const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === microphoneValue);
            if (!selectedOption) return { visible: false };
            
            const soundTabIndex = parseInt(selectedOption[1], 10) - 1;
            if (!AIBoxState.Tab[soundTabIndex]) return { visible: false };
            
            const deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;
            const deviceName = Object.keys(gMicSelect_Index).find(key => gMicSelect_Index[key] === deviceIndex);
            
            return deviceAudioConfig[deviceName] || { visible: false };
        } catch (error) {
            console.error('Error getting device config:', error);
            return { visible: false };
        }
    }
};

Blockly.JavaScript.forBlock['TriggerConditions'] = function(block) {
    let soundTabIndex = gNowSelectSoundTabIndex;
    if(soundTabIndex <= 24)
    {
        let maxRangeValue =  AIBoxState.Tab[soundTabIndex].RangeArray.length;
        const micParams = {};
        const micCallCameraParams = {};
        const microphone = parseInt(block.getFieldValue('MICROPHONE_VALUE'), 10);  
        const triggerCount = parseInt(block.getFieldValue('TRIGGER_COUNT'), 10);   
        const audioTriggerLevel = block.getFieldValue('AUDIO_TRIGGER_LEVEL');      
        const timeToTrigger = block.getFieldValue('TIME_TRIGGER');                 
        const timeToMute = block.getFieldValue('TIME_MUTE'); 
        let match;
        let match2;
        let ipRegex = /\b(?:\d{1,3}\.){3}\d{1,3}\b/;
        let ip;
        let ip2;
        if(AIBoxState.Tab[soundTabIndex])
        {
            for(let index = 0;index < maxRangeValue;index++)
            {

                if(AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].Camera !== '-1')
                {
                    match = AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].Camera.match(ipRegex);
                    ip = match[0];

                    //console.log('TriggerConditions',' match : ',match);
                }

                
                if(AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].SecondCamera !== '-1')
                {
                    match2 = AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].SecondCamera.match(ipRegex);
                    ip2 = match2[0];
                    //console.log('TriggerConditions',' match2 : ',match2);
                }

                if( (match && match.length > 0 ) || (match2 && match2.length > 0) )
                {
                    micCallCameraParams[AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].PosIndex] = {
                        camera: ip,
                        cameraShow:AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].Camera, 
                        camera2: ip2,
                        cameraShow2:AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].SecondCamera, 
                        preset: AIBoxState.Tab[soundTabIndex].PresetLinkMap[index].Preset
                    };
                } 
            }
        }
        

        micParams['microphone'] = microphone;           
        micParams['microphoneChannel'] = maxRangeValue;             
        micParams['triggerCount'] = triggerCount;       
        micParams['audioTriggerLevel'] = audioTriggerLevel;
        micParams['timeToTrigger'] = timeToTrigger;     
        micParams['timeMute'] = timeToMute;
        micParams['callCamera'] = micCallCameraParams;
        //console.log('micParams -->',micParams);
        const script1 = Blockly.JavaScript.statementToCode(block, 'DO');
        const uniqueId = block.getFieldValue('UNIQUE_ID');
        const priority = block.getFieldValue('Priority');
        addActionEntryIfConnectedToStart(block, 'TriggerConditions');
        return JSON.stringify({
            id: uniqueId,
            AIDirectorCmd: 'SnedTriggerConditions',
            Params: {
                MicrophoneParams: micParams,
                ScriptParams:script1,   
                priority: priority             
            },
        }) + ';\n';
    }
    else
    {
        addMessage('Microphone need select!');

        // addActionEntryIfConnectedToStart(block, 'TriggerConditions');
        
        return JSON.stringify({
            
        }) + ';\n';
    }

};



let gNowSelectSoundTabIndex = 0;
let gMicrophoneSelectBlockIndex = 0;

Blockly.Blocks['MicrophoneSelect'] = {
    init: function() {
        this.microphoneName = [ "Shure:MXA910"]; 
        this.lastmicrophoneName = [ "Shure:MXA910"];   

        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);

        this.appendEndRowInput().appendField(window.LanguageManager.getTranslatedText("Microphone_Select")+" : ")
            .appendField(new Blockly
            .FieldDropdown(gMicrophoneSelectOptionNew, this.onMicrophoneChange.bind(this)), "MICROPHONE_VALUE")
            .appendField(" Status: ")
            .appendField(new Blockly.FieldImage("./images/Disable.png", 12, 12, "*", { alt: "Status", flipRtl: false }), "STATUS_ICON1");
        
        this.microphoneValue = parseInt(gMicrophoneSelectOptionNew, 10);

        this.MicSelect = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Select_channel")+" : ")
            .appendField(new Blockly.FieldDropdown(gMicrophoneSelectChannelOption[0]), "MICROPHONE_SELECT_VALUE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("1","MICROPHONE_SELECT_START")
            .appendField("~")
            .appendField("100","MICROPHONE_SELECT_END")
            .appendField(" )");      

        this.timeToCount = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Trigger_count")+" : ")
            .appendField(new Blockly.FieldNumber(1, 1, 100), "TRIGGER_COUNT")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("1", "TRIGGER_COUNT_START")
            .appendField("~")
            .appendField("100", "TRIGGER_COUNT_END")
            .appendField(" )");

        this.audioTriggerLevel = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Audio_Trigger_Level")+" : ")
            .appendField("50", "AUDIO_TRIGGER_LEVEL")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0", "AUDIO_TRIGGER_LEVEL_START")
            .appendField("~")
            .appendField("100", "AUDIO_TRIGGER_LEVEL_END")
            .appendField(" )");
            
        this.timeToTrigger = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Trigger")+" : ")
            .appendField("0.1", "TIME_TRIGGER")
            .appendField(window.LanguageManager.getTranslatedText("s"), "TIME_TRIGGER_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("0.1"+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_START")
            .appendField("~")
            .appendField("5"+window.LanguageManager.getTranslatedText("s"), "TIME_PRESET_END")
            .appendField(" )");

        this.timeToMute = this.appendEndRowInput()
            .appendField(window.LanguageManager.getTranslatedText("Time_to_Mute")+" : ")
            .appendField("1", "TIME_MUTE")
            .appendField(window.LanguageManager.getTranslatedText("s"), "TIME_MUTE_TYPE")
            .appendField(" ("+window.LanguageManager.getTranslatedText("range")+" : ")
            .appendField("10 "+window.LanguageManager.getTranslatedText("s"), "MUTE_START")
            .appendField("~")
            .appendField("3", "MUTE_END")
            .appendField(" "+window.LanguageManager.getTranslatedText("min")+")");
        
        this.setColour("#62A8AC");
        this.setOutput(true, "MicrophoneSelect");
        this.setInputsInline(true);
        this.setTooltip("Select a microphone from the list.");
        this.setHelpUrl("https://www.youtube.com/watch?v=s2_xaEvcVI0");
        this.MicSelect.setVisible(false);
        this.timeToTrigger.setVisible(false); 
        this.timeToMute.setVisible(false);
        this.timeToCount.setVisible(false);
        this.audioTriggerLevel.setVisible(false);
   },
   onMicrophoneChange: function(newValue) {
        const selectedOption = gMicrophoneSelectOptionNew.find(option => option[1] === newValue);
        let soundTabIndex = parseInt(selectedOption[1],10)-1;
        gNowSelectSoundTabIndex = soundTabIndex;

        if (gMicrophoneSelectChannelOption[soundTabIndex]) 
        {
            let newOptions = gMicrophoneSelectChannelOption[soundTabIndex];
            let dropdown = this.getField("MICROPHONE_SELECT_VALUE");
            if (dropdown) 
            {
                dropdown.menuGenerator_ = newOptions;
                dropdown.setValue(newOptions[0][1]);
            }
        }

        if(AIBoxState.Tab[soundTabIndex])
        {
            let maxRangeValue = AIBoxState.Tab[soundTabIndex].RangeArray.length;
            let audioTriggerLevel = AIBoxState.Tab[soundTabIndex].Advance.AudioTriggerLevel;
            let backHomeTime = AIBoxState.Tab[soundTabIndex].Advance.BackToHomeTime;
            let timeToTrigger = AIBoxState.Tab[soundTabIndex].Advance.TimeToTriggerPreset;
            let deviceIndex = AIBoxState.Tab[soundTabIndex].Microphone.SoundDeviceIndex;

            const displayField = this.getField('MICROPHONE_SELECT_VALUE_END');
            const timeToTriggerField = this.getField('TIME_TRIGGER');
            const timeToMuteField = this.getField('TIME_MUTE');
            const timeToMuteTypeField = this.getField('TIME_MUTE_TYPE');
            const audioTriggerLevelField = this.getField('AUDIO_TRIGGER_LEVEL');
            const audioTriggerLevelStartField = this.getField('AUDIO_TRIGGER_LEVEL_START');
            const audioTriggerLevelEndField = this.getField('AUDIO_TRIGGER_LEVEL_END'); 
            const MicphoneSelectStartField = this.getField('MICROPHONE_SELECT_START');
            const MicphoneSelectEndField = this.getField('MICROPHONE_SELECT_END');


            if(audioTriggerLevelField)
            {
                switch(deviceIndex)
                {
                    case 0:case 1:case 2:case 3:case 4:
                        this.audioTriggerLevel.setVisible(false);
                        break;
                    case 5:case 6:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(-90);
                        audioTriggerLevelEndField.setValue(0);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;
                    case 7:case 8:case 9:case 10:case 11:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(120);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;

                    case 12:case 13:case 14:case 15:case 16:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(126);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;

                    case 17:
                        this.audioTriggerLevel.setVisible(true);
                        audioTriggerLevelField.setVisible(true);
                        audioTriggerLevelStartField.setValue(0);
                        audioTriggerLevelEndField.setValue(60);
                        audioTriggerLevelField.setValue(audioTriggerLevel);
                    break;
                }
            }
            
            switch(deviceIndex)
            {
                case 0:case 1:case 2:case 3:case 4:
                case 11:
                case 13:case 14:case 15:case 16:
                case 17:
                    MicphoneSelectStartField.setValue(1);
                    MicphoneSelectEndField.setValue(maxRangeValue);
                break;
                case 5:case 6:
                    MicphoneSelectStartField.setValue(0);
                    MicphoneSelectEndField.setValue(360);
                break;
                case 7:case 8:case 9:case 10:
                    MicphoneSelectStartField.setValue(-70);
                    MicphoneSelectEndField.setValue(70);
                break;
                case 12:
                    MicphoneSelectStartField.setValue(-180);
                    MicphoneSelectEndField.setValue(180);
                break;
            }
            if(displayField)
            {
                displayField.setValue(maxRangeValue);
            }
            if(timeToMuteField)
            {
                switch(backHomeTime)
                {
                    case 0:
                        timeToMuteField.setValue('off');
                    break;
                    case 1:
                        timeToMuteField.setValue('10');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 2:
                        timeToMuteField.setValue('20');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 3:
                        timeToMuteField.setValue('30');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 4:
                        timeToMuteField.setValue('40');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 5:
                        timeToMuteField.setValue('50');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("s"));
                    break;
                    case 6:
                        timeToMuteField.setValue('1');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                    case 7:
                        timeToMuteField.setValue('2');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                    case 8:
                        timeToMuteField.setValue('3');
                        timeToMuteTypeField.setValue(window.LanguageManager.getTranslatedText("min"));
                    break;
                }
            }
            if(timeToTriggerField)
            {
                switch(timeToTrigger)
                {
                    case 0:
                        timeToTriggerField.setValue('0.1');
                    break;
                    case 1:
                        timeToTriggerField.setValue('0.3');
                    break;
                    case 2:
                        timeToTriggerField.setValue('0.5');
                    break;
                    case 3:
                        timeToTriggerField.setValue('1');
                    break;
                    case 4:
                        timeToTriggerField.setValue('1.5');
                    break;
                    case 5:
                        timeToTriggerField.setValue('2');
                    break;
                    case 6:
                        timeToTriggerField.setValue('3');
                    break;
                    case 7:
                        timeToTriggerField.setValue('4');
                    break;
                    case 8:
                        timeToTriggerField.setValue('5');
                    break;
                }
            }

            this.MicSelect.setVisible(true);
            this.timeToTrigger.setVisible(true);
            this.timeToMute.setVisible(true);
            this.timeToCount.setVisible(true);
        }

        if(newValue == 99)
        {
            this.MicSelect.setVisible(false);
            this.audioTriggerLevel.setVisible(false);
            this.timeToTrigger.setVisible(false);
            this.timeToMute.setVisible(false);
            this.timeToCount.setVisible(false);
        }
   }
};

Blockly.JavaScript.forBlock['MicrophoneSelect'] = function(block) {
    const microphoneValue       = parseInt(block.getFieldValue('MICROPHONE_VALUE'), 10);
    const microphoneSelectValue = parseInt(block.getFieldValue('MICROPHONE_SELECT_VALUE'), 10);
    const timeTriggerIndex      = parseFloat(block.getFieldValue('TIME_TRIGGER'),10);
    const timeMuteIndex         = parseInt(block.getFieldValue('TIME_MUTE'),10);
    const timeMuteTypeIndex     = block.getFieldValue('TIME_MUTE_TYPE');
    const triggerCount          = parseInt(block.getFieldValue('TRIGGER_COUNT'),10);

    let timeTrigger = 0;
    let timeMute = 0;

    timeTrigger = timeTriggerIndex*10;

    if(timeMuteTypeIndex == window.LanguageManager.getTranslatedText("min"))
    {
        timeMute = timeMuteIndex * 600;
    }
    else if(timeMuteTypeIndex == window.LanguageManager.getTranslatedText("s"))
    {
        timeMute = timeMuteIndex * 10;
    }

    let codeArray = [microphoneValue,microphoneSelectValue,timeTrigger,timeMute,triggerCount];
    const code = JSON.stringify(codeArray);
    return [code, Blockly.JavaScript.ORDER_ATOMIC];
};

//------------------------------AE-Layout-----------------------------------
Blockly.Blocks['SetVideoSourcePosition'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Select_Camera_Amount")+" : ")
        .appendField(new Blockly.FieldDropdown([
            ["1", "1"],["2", "2"],["3", "3"],["4", "4"]
        ], this.onCamAmountChange.bind(this)), "CAM_AMOUNT");
        this.inputRows = {};
        this.NowCamAmount = 1;
        for (let index = 1; index <= 4; index++) {
            const CameraValue = this.appendDummyInput().appendField().appendField(`${index}`)
                .appendField(window.LanguageManager.getTranslatedText("By_Cam")+` ${index}`).appendField(": ")
                .appendField(new Blockly.FieldDropdown(this.getCameraOptions.bind(this, index), this.onCameraChange.bind(this, index)),"CAMERA_VALUE"+index);
            this.inputRows[index] = {CameraValue};
            CameraValue.setVisible(index == 1);
        }
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#4C8FFF");
        this.setInputsInline(false);
        this.setCollapsed(false);
        this.onCamAmountChange(this.NowCamAmount);
    },
    onCamAmountChange: function(newValue) {
        const newAmount = parseInt(newValue);
        this.NowCamAmount = newAmount;
        for (let index = 1; index <= 4; index++) {
            let row = this.inputRows[index];
            if(row){
                const lastSelectedIP = this.getFieldValue('CAMERA_VALUE' + index);
                row.CameraValue.setVisible(index <= this.NowCamAmount );
                if(index > this.NowCamAmount)
                {
                    const field = this.getField("CAMERA_VALUE" + index);
                    field.setValue("0");
                }
            }
        }
    },
    onCameraChange: function(index, newValue) {
        let duplicateIndex = -1;
    
        for (let i = 1; i <= this.NowCamAmount; i++) 
        {
            let row = this.inputRows[i];
            if(row && index != i)
            {
                const lastSelectedIP = this.getFieldValue('CAMERA_VALUE' + i);
                if(newValue != '0')
                {
                    if (lastSelectedIP == newValue) 
                    {
                        duplicateIndex = i;
                        const field = this.getField("CAMERA_VALUE" + i);
                        field.setValue("0");                    
                    }
                }
            }
        }
    },
    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    },
    updateAllCameraDropdowns: function(excludeIndex) {
        for (let index = 1; index <= 4; index++) {
            if (index !== excludeIndex) {
                const field = this.getField("CAMERA_VALUE" + index);
                if (field) {
                    field.menuGenerator_ = this.getCameraOptions(index);
                    const currentValue = field.getValue();
                    // If the current value is no longer in the dropdown options, reset it to the default
                    if (!field.menuGenerator_.some(option => option[1] === currentValue)) {
                        field.setValue(field.menuGenerator_[0][1]);
                    }
                    field.setValue(field.getValue());
                }
            }
        }
    }
};

Blockly.JavaScript.forBlock['SetVideoSourcePosition'] = function(block) {
    const cameraAmount = parseInt(block.getFieldValue('CAM_AMOUNT'),10);
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'SetVideoSourcePosition');
    var cameraJSON = {};
    for (let index = 1; index <= cameraAmount; index++) 
    {
        const ip = block.getFieldValue('CAMERA_VALUE'+index);
        let key = `cameraInfo${index}`;
        cameraJSON[key] = {
            ip: ip,
        };
    }
    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SetVideoSourcePosition',
        Params: {
            cameraAmount:cameraAmount,
            cameraInfo:cameraJSON,
            priority: priority
        }
    }) + ';\n';
};

Blockly.Blocks['SetVideoSourceLayout'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Select_Video_Layout_Mode")+" : ")
        .appendField(new Blockly.FieldDropdown([
            [window.LanguageManager.getTranslatedText("Cross"), "0"],[window.LanguageManager.getTranslatedText("PBP"), "1"]
        ], this.onLayoutModeChange.bind(this)), "VIDEO_LAYOUT_MODE");
        this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Select_Video_Layout")+" : ")
        .appendField(new Blockly.FieldDropdown(this.getInitialVideoLayoutOptions(), this.onVideoLayoutChange.bind(this)), "VIDEO_LAYOUT");        
        this.VideoLayoutMode = 0;
        this.lastVideoLayoutMode = 0;
        this.VideoLayout = 1;
        this.lastVideoLayout = 1;
        this.CameraAmount = 1;
        this.lastCameraAmount = 1;
        this.inputRows = {};
        
        for (let index = 1; index <= 4; index++) {
            const CameraValue = this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Video_Source_Position")).appendField(`${index}`)
                .appendField(window.LanguageManager.getTranslatedText("By_Cam")+` ${index}`).appendField(": ")
                .appendField(new Blockly.FieldDropdown(this.getCameraOptions,this.onCameraChange.bind(this, index)),"CAMERA_VALUE"+index);
            this.inputRows[index] = {CameraValue};
            CameraValue.setVisible(index == 1);
        }       
        
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#4C8FFF");

        this.setInputsInline(false);
        this.setCollapsed(false);
        this.onLayoutModeChange(1);
    },
    onChangeLayoutVisable: function() {
        for (let index = 1; index <= 4; index++) {
            const row = this.inputRows[index];
            if(index <= this.CameraAmount){
                row.CameraValue.setVisible(true);
            } else {
                row.CameraValue.setVisible(false);
            }
            if(index > this.CameraAmount)
            {
                const field = this.getField("CAMERA_VALUE" + index);
                field.setValue("0");
            }
        }
    },
    onLayoutModeChange: function(newValue) {
        const layoutMode = parseInt(newValue,10);
        this.VideoLayoutMode = layoutMode;
        let videoLayoutOptions;
        if (layoutMode === 1) {
            videoLayoutOptions = this.getPBPVideoLayoutOptions();
        } else {
            videoLayoutOptions = this.getInitialVideoLayoutOptions();
        }
        const videoLayoutField = this.getField('VIDEO_LAYOUT');
        videoLayoutField.menuGenerator_ = videoLayoutOptions;
        videoLayoutField.setValue(videoLayoutOptions[0][1]);

        if(this.lastVideoLayoutMode != this.VideoLayoutMode){
            this.lastVideoLayoutMode = this.VideoLayoutMode;
            this.onChangeLayoutVisable();
        }
    },
    onVideoLayoutChange: function(newValue) {
        const layout = parseInt(newValue);
        this.VideoLayout = layout;
        this.CameraAmount = layout;
        if(this.lastVideoLayout != this.VideoLayout){
            this.lastVideoLayout = this.VideoLayout;
            this.onChangeLayoutVisable();
        }
    },
    onCameraChange: function(index, newValue) {
        let duplicateIndex = -1;
    
        for (let i = 1; i <= 4; i++) 
        {
            if(i <= this.CameraAmount)
            {
                let row = this.inputRows[i];
                if(row && index != i)
                {
                    const lastSelectedIP = this.getFieldValue('CAMERA_VALUE' + i);
                    if(newValue != '0')
                    {
                        if (lastSelectedIP == newValue) 
                        {
                            duplicateIndex = i; 
                            const field = this.getField("CAMERA_VALUE" + i);
                            field.setValue("0");
                        }
                    }
                }
            }
        }
    },
    getCameraOptions: function() {
        return getLatestDropdownOptions().length > 0 ? getLatestDropdownOptions() : [["None available", "NONE"]];
    },
    getInitialVideoLayoutOptions: function() {
        return [
            ["1x1", "1"], ["1x2", "2"], ["1x3", "3"], ["2x2", "4"]
        ];
    },
    getPBPVideoLayoutOptions: function() {
        return [
            ["1x1", "1"], ["1x2", "2"], ["1x3", "3"], ["1x4", "4"]
        ];
    }
};

Blockly.JavaScript.forBlock['SetVideoSourceLayout'] = function(block) {
    const videoLayoutmode = parseInt(block.getFieldValue('VIDEO_LAYOUT_MODE'),10);
    const videoLayout = parseInt(block.getFieldValue('VIDEO_LAYOUT'),10);
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');

    addActionEntryIfConnectedToStart(block, 'SetVideoSourcePosition');
    var cameraJSON = {};
    for (let index = 1; index <= videoLayout; index++) {
        const ip = block.getFieldValue('CAMERA_VALUE'+index);
        let key = `cameraInfo${index}`;
        cameraJSON[key] = {
            ip: ip,
        };
    }
    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SetVideoSourceLayout',
        Params: {
            videoLayoutmode: videoLayoutmode,
            cameraInfo:cameraJSON,
            priority: priority
        }
    }) + ';\n';
};


Blockly.Blocks['SetSeamlessSwitching'] = {
    init: function() {
        const uniqueId = generateUniqueId();
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Select_Video_Layout_Mode")+" : ")
        .appendField(new Blockly.FieldDropdown([
            [window.LanguageManager.getTranslatedText("Seamless_Switch"), "0"],[window.LanguageManager.getTranslatedText("No_Switch"), "1"]
        ]), "VIDEO_LAYOUT_MODE");        
        this.setPreviousStatement(true,'script_connection');
        this.setNextStatement(true,'script_connection');
        this.setColour("#4C8FFF");

        this.setInputsInline(false);
        this.setCollapsed(false);
    }
};

Blockly.JavaScript.forBlock['SetSeamlessSwitching'] = function(block) {
    const videoLayoutmode = parseInt(block.getFieldValue('VIDEO_LAYOUT_MODE'),10);
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'SetSeamlessSwitching');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SetSeamlessSwitching',
        Params: {
            videoLayoutmode: videoLayoutmode,
            priority: priority
        }
    }) + ';\n';
};




//------------------------------AE-Control-----------------------------------
Blockly.Blocks['AfterReschedule'] = {
    init: function() {
      const uniqueId = generateUniqueId();  
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
      const currentPriority = scriptList.length + 1;
      this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
      this.appendDummyInput()
          .appendField(window.LanguageManager.getTranslatedText("Reschedule_in_1"))
          .appendField(new Blockly.FieldNumber(1, 0.1), "RESCHEDULE_DELAY").appendField(window.LanguageManager.getTranslatedText("Reschedule_in_2"));
          
      this.appendStatementInput("DO")
          .setCheck('script_connection')
          .appendField(window.LanguageManager.getTranslatedText("execution"));
      this.setPreviousStatement(true,'script_connection');
      this.setNextStatement(true,'script_connection');
      this.setColour(230);
      this.setTooltip("schedule After - Reschedule");
      this.setHelpUrl("");
    }
};
Blockly.JavaScript.forBlock['AfterReschedule'] = function(block) {
    const delay = block.getFieldValue('RESCHEDULE_DELAY');
    const script = Blockly.JavaScript.statementToCode(block, 'DO');
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'AfterReschedule');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SendAfterReschedule',
        Params: {
            delay: delay,
            script:script,
            priority: priority
        }
    }) + ';\n';
};
Blockly.Blocks['RepeatCount'] = {
  init: function() {
    const uniqueId = generateUniqueId();  
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
    const currentPriority = scriptList.length + 1;
    this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
    this.appendDummyInput()
        .appendField(window.LanguageManager.getTranslatedText("Repeat_Count")+" : ")
        .appendField(new Blockly.FieldNumber(10, 1, 1000, 1), "COUNT");
    this.appendStatementInput("DO").appendField(window.LanguageManager.getTranslatedText("do")).setCheck('script_connection');
    this.setPreviousStatement(true,'script_connection');
    this.setNextStatement(true,'script_connection');
    this.setColour(60);
    this.setTooltip("Repeat Count");
    this.setHelpUrl("");
  }
};
Blockly.JavaScript.forBlock['RepeatCount'] = function(block) {
    const count = parseInt(block.getFieldValue('COUNT'),10);
    const script = Blockly.JavaScript.statementToCode(block, 'DO');
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');
    addActionEntryIfConnectedToStart(block, 'SendRepeatCount');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'SendRepeatCount',
        Params: {
            count: count,
            script:script,
            priority: priority
        }
    }) + ';\n';
};

Blockly.Blocks['RepeatLoop'] = {
    init: function() {
        const uniqueId = generateUniqueId();  
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(uniqueId), "UNIQUE_ID").setVisible(false);
        const currentPriority = scriptList.length + 1;
        this.appendDummyInput().appendField(new Blockly.FieldLabelSerializable(currentPriority.toString()), "Priority").setVisible(false);
        this.appendDummyInput().appendField(window.LanguageManager.getTranslatedText("Loop_Script"));
        this.appendStatementInput("DO").appendField(window.LanguageManager.getTranslatedText("do")).setCheck('script_connection');
        this.setPreviousStatement(true,'loop_script_connection');
        this.setNextStatement(true,'loop_script_connection_end');
        this.setColour(120);
        this.setTooltip("");
        this.setHelpUrl("");
        this.setInputsInline(false);
        this.setCollapsed(false);
    }
};

Blockly.JavaScript.forBlock['RepeatLoop'] = function(block){
    const script = Blockly.JavaScript.statementToCode(block, 'DO');
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const priority = block.getFieldValue('Priority');

    addActionEntryIfConnectedToStart(block, 'RepeatLoop');

    return JSON.stringify({
        id: uniqueId,
        AIDirectorCmd: 'RepeatLoop',
        Params: {
            script:script,
            priority: priority
        }
    }) + ';\n';
};

//------------------------------other-----------------------------------
let GetPreviewCamera;
let idActionList = [];
let latestCameraOptions = [["None available", "NONE"]]; 
let latestCameraOptions_lite = [["None available", "NONE"]]; 

function stopCode() {
    shouldStopExecution = true;
    let jsonmsg = {AIDirectorCmd: 'SetScriptStop'};
    AiDirector_websocket.send(JSON.stringify(jsonmsg));
}

function addActionEntry(block, action) {
    const uniqueId = block.getFieldValue('UNIQUE_ID');
    const actionEntry = {
        id: uniqueId,
        action: action,
        timestamp: new Date().toISOString()
    };
    idActionList.push(actionEntry);
}

function addActionEntryIfConnectedToStart(block, action) {
    const startBlock = getConnectedStartBlock(block);
    if (startBlock) {
        const startPriority = startBlock.getFieldValue('Priority');
        if (checkPriorityOrder(startPriority)) 
        {
            addActionEntry(block, action);
        } 
        else 
        {
            reorderScriptList();
            addActionEntry(block, action);
        }
    }
}

function checkPriorityOrder(priority) {
    if (scriptList.length === 0) return true;

    const lastScript = scriptList[scriptList.length - 1];
    if (parseInt(priority) >= lastScript.priority) {
        return true;
    }
    return false;
}

function reorderScriptList() {

    scriptList.sort((a, b) => a.priority - b.priority);

    for (let i = 0; i < scriptList.length; i++) {
        scriptList[i].priority = i + 1;

        let block = workspace.getBlockById(scriptList[i].id);
        if (block) {
            const startBlock = getConnectedStartBlock(block);
            if (startBlock) {
                const newPriority = startBlock.getFieldValue('Priority');
                block.setFieldValue(newPriority, 'Priority');
            }
        }
    }
}

function generateUniqueId() {
    var timestampPart = Date.now().toString(36).substring(4,7);
    var randomPart = Math.random().toString(36).substring(2,6);
    return timestampPart + randomPart;
}

// const microphoneNames = {
//     '1':  'Shure:MXA910',
//     '2':  'Shure:MXA920',
//     '3':  '(Beta)Shure:MXA920(Coordinate)',
//     '4':  'Shure:MXA710',
//     '5':  'Shure:MXA310',
//     '6':  'Shure:MXCW',
//     '7':  'Shure:P300',
//     '8':  'Sennheiser:TCC2',
//     '9':  'Sennheiser:TCCM',
//     '10':  'Sennheiser:TCC2(Coordinate)',
//     '11': 'Sennheiser:TCC2(Coordinate)',
//     '12': 'Nureva:HDL300',
//     '13': 'Nureva:Dual HDL300',
//     '14': 'Nureva:HDL310',
//     '15': 'Nureva:HDL410',
//     '16': 'Nureva:HDL410(Coordinate)',
//     '17': 'Yamaha:RM-CR',
//     '18': 'Yamaha:RM-CG',
//     '19': 'Yamaha:RM-W',
//     '20': 'Yamaha:RM-TT',
//     '21': 'Audio-Technica:ATND1061',
//     '22': 'Audio-Technica:ATND1061(Coordinate)'
// };

const microphoneNames = {
    '1':  'Shure:MXA910',
    '2':  'Shure:MXA920',
    '3':  'Shure:MXA920(Coordinate)',
    '4':  'Shure:MXA710',
    '5':  'Shure:MXA310',
    '6':  'Shure:MXCW',
    '7':  'Shure:P300',
    '8':  'Sennheiser:TCC2',
    '9':  'Sennheiser:TCCM',
    '10':  'Sennheiser:TCC2(Coordinate)',
    '11': 'Sennheiser:TCC2(Coordinate)',
    '12': 'Nureva:HDL300',
    '13': 'Nureva:Dual HDL300',
    '14': 'Nureva:HDL310',
    '15': 'Nureva:HDL410',
    '16': 'Nureva:HDL410(Coordinate)',
    '17': 'Yamaha:RM-CR',
    '18': 'Yamaha:RM-CG',
    '19': 'Yamaha:RM-W',
    '20': 'Yamaha:RM-TT',
    '21': 'Audio-Technica:ATND1061',
    '22': 'Audio-Technica:ATND1061(Coordinate)'
};

function microphoneDisplayname(microphoneIndex) {
    let microphoneName = microphoneNames[microphoneIndex] || "Unknown Microphone"; 
    return (microphoneName+' is selected');
}

function cameraDisplayname(cameraString) {
    let camera_value = cameraString; 
    return (camera_value +' is selected');
}

function getLatestDropdownOptions() {
  return latestCameraOptions;
}

function refreshDropdowns() {
    var allBlocks;
    if(workspace)
        allBlocks = workspace.getAllBlocks();
    if(allBlocks)
    {
        allBlocks.forEach(function(block) {
            if (block && ['CallCameraPresetWithList','SetCameraPresetSpeedWithList',
                          'CallCameraHomeWithList','SendCameraHEXCommands','CallMultiCameraPresetCruise'].includes(block.type)) 
            {
                var dropdownField = block.getField("NAME");
                if(dropdownField) 
                {
                    dropdownField.setValue(null);
    
                    if(!latestCameraOptions.length) 
                    {
                        latestCameraOptions = [["None available", "NONE"]];
                    }
                    
                    dropdownField.menuGenerator_ = latestCameraOptions;
                    dropdownField.setValue(latestCameraOptions[0][1]);
                }
            }
        });
    }
}

function refreshWorkspace() {
    var workspaceXml = Blockly.Xml.workspaceToDom(workspace);
    var xmlText = Blockly.Xml.domToText(workspaceXml);
    workspace.clear();
    var xml = Blockly.Xml.textToDom(xmlText);
    Blockly.Xml.domToWorkspace(xml, workspace);
}

//----------------Blockly.Function-------------------

var mouseState = {
    isDragging: false,
    lastX: 0,
    lastY: 0
};

function initializeBlocklyZoom() {
    if (workspace) {
        var blocklyArea = workspace.getParentSvg();

        blocklyArea.addEventListener('wheel', function(event) {
            var deltaY = event.deltaY;
            var mouseX = mouseState.lastX;
            var mouseY = mouseState.lastY;
            var workspaceScale = workspace.scale;
            var newScale = workspaceScale;

            if (deltaY > 0) {
                newScale = workspaceScale / 1.1;
            } else if (deltaY < 0) {
                newScale = workspaceScale * 1.1;
            }

            if (newScale !== workspaceScale) {
                var metrics = workspace.getMetrics();
                var newOriginX = mouseX;
                var newOriginY = mouseY;

                workspace.setScale(newScale);
                workspace.scroll(newOriginX, newOriginY);
            }

            event.preventDefault();
        });

        blocklyArea.addEventListener('mousedown', function(event) {
            mouseState.isDragging = true;
            mouseState.lastX = event.clientX;
            mouseState.lastY = event.clientY;
        });
    }
}

function createNormalModeButtonArray(){
    const container = document.getElementById('DirectorNormalMode_container');
    const containerWidth = container.offsetWidth;
    const gapSize = parseInt(getComputedStyle(container).gap);
    const paddingSize = parseInt(getComputedStyle(container).paddingLeft) * 2;
    const buttonsPerRow = 10;

    const hideArea = document.getElementById('DirectorNormalMode_hideArea');
    let draggedItem = null;
    let placeholder = document.createElement('div');
    placeholder.className = 'placeholder';


    for (let i = 1; i <= 5; i++) {
        createButton(i);
    }
    adjustButtonSizes();

    container.addEventListener('dragstart', (e) => {
        if (e.target.className.includes('button')) {
            draggedItem = e.target;
            e.target.classList.add('dragging');
            e.target.style.opacity = 0.5;
            placeholder.style.height = `${draggedItem.offsetHeight}px`;
            container.insertBefore(placeholder, draggedItem.nextSibling);
        }
    });

    container.addEventListener('dragend', (e) => {
        e.target.classList.remove('dragging');
        e.target.style.opacity = '';
        if (placeholder.parentNode) {
            container.insertBefore(draggedItem, placeholder);
            container.removeChild(placeholder);
        }
        adjustButtonSizes();
    });

    container.addEventListener('dragover', (e) => {
        e.preventDefault();
        const afterElement = getDragAfterElement(container, e.clientX, e.clientY);
        if (afterElement) {
            container.insertBefore(placeholder, afterElement);
        } else {
            container.appendChild(placeholder);
        }
    });

    hideArea.addEventListener('dragover', (e) => {
        e.preventDefault();
    });

    hideArea.addEventListener('drop', (e) => {
        e.preventDefault();
        if (draggedItem) {
            draggedItem.style.display = 'none';
            container.removeChild(placeholder);
            adjustButtonSizes();
        }
    });
    
    function getDragAfterElement(container, x, y) {
        const draggableElements = [...container.querySelectorAll('.DirectorNormalMode-button:not(.dragging):not(.placeholder)')];
        let closest = { offset: Number.POSITIVE_INFINITY, element: null };
        
        draggableElements.forEach(child => {
            const box = child.getBoundingClientRect();
            const offsetX = x - (box.left + box.width / 2);
            const offsetY = y - (box.top + box.height / 2);
            const offset = Math.sqrt(offsetX ** 2 + offsetY ** 2);
    
            if (offset < closest.offset) {
                closest = { offset, element: child };
            }
        });
    
        return closest.element;
    }
    
    
    function adjustButtonSizes() {
        const visibleButtons = container.querySelectorAll('.DirectorNormalMode-button:not([style*="display: none"])');
        const buttonCount = visibleButtons.length;
        let newWidth = 100;
        let newGap;

        newWidth = Math.max(100, containerWidth / buttonCount - gapSize * (buttonCount - 1) / buttonCount);
        newGap = gapSize;

        container.style.gap = `${newGap}px`;
        visibleButtons.forEach(button => {
            button.style.width = `${newWidth}px`;
            button.style.height = "256px";
            button.style.height = "144px";
        });
    }
}

//easy mode
let shouldRunCode = false;
let indexMap = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]; 
let defaultModeTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let modeTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let defaultbtnTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let btnTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let btnImages = [
    '../imagesaibox/director/PBP mode.jpg',
    '../imagesaibox/director/Conversion mode.jpg',
    '../imagesaibox/director/Teaching mode.jpg',
    '../imagesaibox/director/Q&A mode.jpg',
];

let runmodeTexts = [
    "Single Execution",
    "Loop Execution"
]

let changesmodeTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let changesbtnTexts = [
    "Conversation",
    "Presenter",
    "Cruise",
    "Customize1",
    "Customize2",
];

let buttonActions = {
    "Script 1":  () => actionForMode(0),
    "Script 2":  () => actionForMode(1),
    "Script 3":  () => actionForMode(2),
    "Script 4":  () => actionForMode(3),
    "Script 5":  () => actionForMode(4),
    "Script 6":  () => actionForMode(5),
    "Script 7":  () => actionForMode(6),
    "Script 8":  () => actionForMode(7),
    "Script 9":  () => actionForMode(8),
};

async function actionForMode(index) {
    try {
        await asyncFunction(index);
    } catch (error) {
        console.error(error); // Using console.error for errors to differentiate from other logs
    } finally {
        currentModeIndex++; // Assuming currentModeIndex is declared in the right scope
    }
}

async function asyncFunction(index) {
    await runFunction(index)
        .then(() => console.log("Async Function "+index+" is running"))
        .catch(error => { throw error; });
}

function runFunction(index) {
    return new Promise((resolve, reject) => {
        const interval = setInterval(() => {
            if (shouldStop) {
                //console.log("Execution stopped");
                clearInterval(interval);
            }
        }, 50);

        shouldRunCode = true; // Set the flag to run code when the data is received

        const checkIfDone = setInterval(() => {
            if (!shouldRunCode) { // Check if runCode has been called
                //console.log('Execution complete');
                clearInterval(interval);
                clearInterval(checkIfDone);
                resolve();
            }
        }, 50);
    });
}

function checkStopCondition() {
    return new Promise((resolve, reject) => {
        const interval = setInterval(() => {
            if (shouldStop) {
                //console.log("Execution stopped");
                clearInterval(interval);
            }
        }, 50);

        setTimeout(() => {
            clearInterval(interval);
            if (!shouldStop) {
                resolve();
            }
        }, 500); // Adjust timing as necessary
    });
}

async function asyncFunction1() {
    await checkStopCondition()
        .then(() => console.log("Async Function 1 is running"))
        .catch(error => { throw error; });
}

async function asyncFunction2() {
    await checkStopCondition()
        .then(() => console.log("Async Function 2 is running"))
        .catch(error => { throw error; });
}

async function asyncFunction3() {
    await checkStopCondition()
        .then(() => console.log("Async Function 3 is running"))
        .catch(error => { throw error; });
}

function SettingUIoptinstatus(status){
    const runmodeSelect     = document.getElementById('DirectorNormalMode-runmodeSelect');
    const runmodeName       = document.getElementById('DirectorNormalMode-modeName');
    const runModeApply      = document.getElementById('DirectorNormalMode-applyChanges');
    const runModeEdit       = document.getElementById('DirectorNormalMode-editChanges');
    const runModeCancel     = document.getElementById('DirectorNormalMode-cancelChanges');
    const runmodereset      = document.getElementById('DirectorNormalMode-resetChanges');
    const modeSelect        = document.getElementById('DirectorNormalMode-modeSelect');
    const modeSelectEdit    = document.getElementById('DirectorNormalMode-modeSelectEdit');
    const runmodeCodestatus = document.getElementById('DirectorNormalMode-codestatus');

    if(runmodeSelect)     runmodeSelect.disabled     =  status;
    if(runmodeName)       runmodeName.disabled       =  status;
    if(runModeApply)      runModeApply.disabled      =  status; 
    if(runModeEdit)       runModeEdit.disabled       =  status;
    if(runModeCancel)     runModeCancel.disabled     =  status;
    if(runmodereset)      runmodereset.disabled      =  status;
    if(modeSelect)        modeSelect.disabled        =  status;
    if(modeSelectEdit)    modeSelectEdit.disabled    =  status;
    if(runmodeCodestatus) runmodeCodestatus.disabled = !status;
}

let gGetProfileNoDisplayWorkspace = false;
let gEasyModeRunWithoutWorkSpace = false;
let gLastAIDirectorModeIndex = 0;
let gOrderedSelectedIds = 0;
function AiDirector_initEasyMode(){
    createNormalModeButtonArray();
    updateDropdown();
    updateButtonSelectionStates();

    const runmodeCodestop = document.getElementById('DirectorNormalMode-codestatus');
    
    if(runmodeCodestop) {
        runmodeCodestop.disabled = true;
    }

    const applyButton = document.getElementById('DirectorNormalMode-applyChanges');
    
    if (applyButton) {
        applyButton.addEventListener('click', function() {
            const selectedModeIndex = document.getElementById('DirectorNormalMode-modeSelect').value;
            const newName = document.getElementById('DirectorNormalMode-modeName').value.trim();
            if (newName !== '') {
                const oldName = modeTexts[selectedModeIndex];
                updateBtnTextAndAction(oldName, newName);
            
                createNormalModeButtonArray();
                updateDropdown();
                updateButtonSelectionStates();
                document.getElementById('DirectorNormalMode-modeName').value = '';
            } else {
                alert("Mode name cannot be empty.");
            }
        });
    } 

    const cancelButton = document.getElementById('DirectorNormalMode-cancelChanges');
    if (cancelButton) {
        cancelButton.addEventListener('click', function() {
            const selectedModeIndex = document.getElementById('DirectorNormalMode-modeSelect').selectedIndex;
            btnTexts[selectedModeIndex] = defaultbtnTexts[selectedModeIndex];

            createNormalModeButtonArray();
            updateDropdown();
            updateButtonSelectionStates();
            document.getElementById('DirectorNormalMode-modeName').value = '';
        });
    }

    const resetButton = document.getElementById('DirectorNormalMode-resetChanges');
    if (resetButton) {
        resetButton.addEventListener('click', function() {
            btnTexts = [...defaultbtnTexts];
            modeTexts = [...defaultModeTexts];
            selectedIds = [];

            createNormalModeButtonArray();
            updateDropdown();
            updateButtonSelectionStates();
        
        });
    }

    const updateOrderedSelectedIds = () => {
        orderedSelectedIds = selectedIds.slice();
    };  

    document.querySelectorAll('.DirectorNormalMode-button-wrapper').forEach(wrapper => {
        wrapper.addEventListener('click', function() {
            const modeText = this.querySelector('.DirectorNormalMode-modeText');
            if (modeText.classList.contains('show-modeText')) {
                modeText.classList.remove('show-modeText');
            } else {
                document.querySelectorAll('.DirectorNormalMode-button-wrapper .DirectorNormalMode-modeText').forEach(mt => {
                    mt.classList.remove('show-modeText');
                });
                modeText.classList.add('show-modeText');
            }
        });
    });

    function createNormalModeButtonArray() {
        const container = document.getElementById('DirectorNormalMode_container');
        if(container)
        {
            container.innerHTML = ''; 
            modeTexts.forEach((modeDescription, index) => {
                createButton(index + 1, modeDescription);
            });
        }
        else
        {
            return;
        }
    }

    function updateDropdown() {
        const modeSelect = document.getElementById('DirectorNormalMode-modeSelect');
        const modeSelectEdit = document.getElementById('DirectorNormalMode-modeSelectEdit');
        const runmodeSelect = document.getElementById('DirectorNormalMode-runmodeSelect');

        if(modeSelect)
        {
            modeSelect.innerHTML = '';
            btnTexts.forEach((text, index) => {
                const option = document.createElement('option');
                option.value = index;
                option.textContent = text;
                modeSelect.appendChild(option); 
                modeSelect.value = lastModeIndexChangeName;
    
            });
        }

        if(modeSelectEdit)
        {
            modeSelectEdit.innerHTML = '';
            btnTexts.forEach((text, index) => {
                const option = document.createElement('option');
                option.value = index;
                option.textContent = text;
                modeSelectEdit.appendChild(option);
            });
        }

        if(runmodeSelect)
        {
            runmodeSelect.innerHTML = '';
            runmodeTexts.forEach((text, index) => {
                const option = document.createElement('option');
                option.value = index;
                option.textContent = text;
                runmodeSelect.appendChild(option);
            });
        }

    }

    function createButton(index, modeDescription) {
        const container = document.getElementById('DirectorNormalMode_container');
        let wrapper = document.createElement('div');
        wrapper.id = 'DirectorNormalMode-button-wrapper'+index;
        if(index == 2 || index == 3)
            wrapper.className = 'DirectorNormalMode-button-wrapper fade-color';
        else
            wrapper.className = 'DirectorNormalMode-button-wrapper';

        wrapper.draggable = true;
        wrapper.setAttribute('data-index', index);
            let btn = document.createElement('div');
            btn.id = 'DirectorNormalMode-button'+index;
            btn.className = 'DirectorNormalMode-button';
                let underline = document.createElement('span');
                underline.className = 'DirectorNormalMode-underline';   
                let imgLabel = document.createElement('label');
                imgLabel.className = 'Font_Arial_18_bold mic-xy-title';
                imgLabel.textContent = modeDescription;
            btn.appendChild(imgLabel);
            btn.appendChild(underline); 
                    
            let modeTextElement = document.createElement('span');
            modeTextElement.style.display = 'block';
            modeTextElement.className = 'DirectorNormalMode-modeText';
            modeTextElement.textContent = modeDescription;

            let changeModeDescription = modeDescription;
            if(modeDescription.includes('Conversation'))
            {
                changeModeDescription = window.LanguageManager.getTranslatedText("Conversation");
            }
            if(modeDescription.includes('Presenter'))
            {
                changeModeDescription = window.LanguageManager.getTranslatedText("Presenter");
            }
            if(modeDescription.includes('Cruise'))
            {
                changeModeDescription = window.LanguageManager.getTranslatedText("Cruise");
            }
            if(modeDescription.includes('Customize'))
            {
                const match = modeDescription.match(/Customize(\d+)/);
                if (match && match[1]) 
                {
                  const customizeNumber = match[1];
                  changeModeDescription = window.LanguageManager.getTranslatedText("Customize")+" "+customizeNumber;
                }
            }
            imgLabel.textContent = changeModeDescription;
            modeTextElement.textContent = changeModeDescription;

        wrapper.appendChild(btn);
        wrapper.appendChild(modeTextElement);
        wrapper.setAttribute('data-id', btnTexts[index - 1]);
        wrapper.setAttribute('data-index', index.toString());

        adjustModeTextPosition(index, modeTextElement, modeTexts.length);

        btn.addEventListener('click', function(event) {
            event.stopPropagation();
            let editbuttondisabled = document.getElementById('DirectorNormalMode-editChanges');
            let runbuttondisabled = document.getElementById('DirectorNormalMode-codestaus');
            const id = wrapper.getAttribute('data-id');
            const isSelected = this.classList.toggle('DirectorNormalMode-button-selected');
            let currentSelected = document.querySelector('.DirectorNormalMode-button-selected');
            
            if (currentSelected && currentSelected !== this) 
            {
                currentSelected.classList.remove('DirectorNormalMode-button-selected');
            }

            if (isSelected) 
            {
                selectedIds = [];
                selectedIds.push(id);
                selectedButtonId =  id;
            } 
            else 
            {
                selectedIds = [];
                selectedButtonId = null;
            }            
            if(selectedButtonId == null)
            {
                AiDirector_sendMessage("GetSystemSettingForDirector");
                gEditScriptID = -1;
                editbuttondisabled.disabled=true;
                if(runbuttondisabled)
                    runbuttondisabled.disabled=true;
            }
            else
            {
                gEditScriptID = defaultbtnTexts.indexOf(selectedButtonId);
                editbuttondisabled.disabled=false;
                if(runbuttondisabled)
                    runbuttondisabled.disabled=false;
            }
            
            printSelectedButtonOrder();
        });

        container.appendChild(wrapper);
    }

    function updateButtonSelectionStates() {
        const allButtons = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
        allButtons.forEach(wrapper => {
            const id = wrapper.getAttribute('data-id');
            const btn = wrapper.querySelector('.DirectorNormalMode-button');
            if (selectedIds.includes(id)) {
                btn.classList.add('DirectorNormalMode-button-selected');
            } else {
                btn.classList.remove('DirectorNormalMode-button-selected');
            }
        });
    }

    function printSelectedButtonOrder() {
        const allWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
        let currentOrderIndexes = Array.from(allWrappers).map(wrapper => parseInt(wrapper.getAttribute('data-index')) - 1);
        let selectedIndexes = selectedIds.map(id => modeTexts.indexOf(id)).filter(index => index !== -1);
        let notSelectedIndexes = currentOrderIndexes.filter(index => !selectedIndexes.includes(index));

        let currentOrderIds = Array.from(allWrappers).map(wrapper => wrapper.getAttribute('data-id'));
        let orderedSelectedIds = currentOrderIds.filter(id => selectedIds.includes(id));
        let orderedNotSelectedIds = currentOrderIds.filter(id => !selectedIds.includes(id));


        if(selectedIndexes.length == 0 )
        {
            gAIDirectorSelectedIndex = -1;
        }
        else
        {
            gAIDirectorSelectedIndex = parseInt(selectedIndexes,10);
        }
        
        updateButtonSelectionStates();
    }

    function setDragListeners(wrapper) {
        wrapper.addEventListener('dragstart', e => {
            draggedIndex = parseInt(wrapper.getAttribute('data-index')) - 1;
            e.dataTransfer.setData('text/plain', draggedIndex);
        });

        wrapper.addEventListener('dragover', e => {
            e.preventDefault();
        });

        wrapper.addEventListener('drop', e => {
            e.preventDefault();
            const sourceIndex = draggedIndex;
            const targetIndex = parseInt(e.currentTarget.getAttribute('data-index')) - 1;
            swapAndReorder(sourceIndex, targetIndex);
        });

        // wrapper.addEventListener('mouseover', () => {
        //     const modeText = wrapper.querySelector('.DirectorNormalMode-modeText');
        //     if (modeText) {
        //         modeText.style.display = 'block';
        //     }
        // });

        // wrapper.addEventListener('mouseout', () => {
        //     const modeText = wrapper.querySelector('.DirectorNormalMode-modeText');
        //     if (modeText) {
        //         modeText.style.display = 'none';
        //     }
        // });
    }   


    function onUserChangedModeName(oldName, newName) {
        updateBtnTextAndAction(oldName, newName);
        createNormalModeButtonArray();
        updateDropdown();
        updateButtonSelectionStates();
    }

    function swapAndReorder(sourceIndex, targetIndex) {
        [btnTexts[sourceIndex], btnTexts[targetIndex]] = [btnTexts[targetIndex], btnTexts[sourceIndex]];
        [btnImages[sourceIndex], btnImages[targetIndex]] = [btnImages[targetIndex], btnImages[sourceIndex]];
        [changesbtnTexts[sourceIndex], changesbtnTexts[targetIndex]] = [changesbtnTexts[targetIndex], changesbtnTexts[sourceIndex]];
        [modeTexts[sourceIndex], modeTexts[targetIndex]] = [modeTexts[targetIndex], modeTexts[sourceIndex]];
        [changesmodeTexts[sourceIndex], changesmodeTexts[targetIndex]] = [changesmodeTexts[targetIndex], changesmodeTexts[sourceIndex]];
        [indexMap[sourceIndex], indexMap[targetIndex]] = [indexMap[targetIndex], indexMap[sourceIndex]];    

        createNormalModeButtonArray();
        updateDropdown();
        updateButtonSelectionStates();
        printSelectedButtonOrder();
    }

    function getDragAfterElement(container, x) {
        const draggableElements = [...container.querySelectorAll('.DirectorNormalMode-button-wrapper:not(.dragging)')];

        return draggableElements.reduce((closest, child) => {
            const box = child.getBoundingClientRect();
            const offset = x - box.left - box.width / 2; 
            if (offset < 0 && offset > closest.offset) {
                return { offset: offset, element: child };
            } else {
                return closest;
            }
        }, { offset: Number.NEGATIVE_INFINITY }).element; 
    }

    function updateBtnTextAndAction(oldText, newText) {
        const modeIndex = modeTexts.findIndex(text => text === oldText);
        if (modeIndex !== -1) {
            modeTexts[modeIndex] = newText;
            btnTexts[modeIndex] = newText;  
            lastModeIndexChangeName = modeIndex;
        }

        const actionKey = Object.keys(buttonActions).find(key => buttonActions[key].toString().includes(`actionForMode(${modeIndex + 1})`));
        if (actionKey && oldText !== newText) {
            delete buttonActions[actionKey];
            buttonActions[newText] = () => actionForMode(modeIndex + 1);
        }   
        const selectedIndex = selectedIds.indexOf(oldText);
        if (selectedIndex !== -1) {
            selectedIds[selectedIndex] = newText;
        }

        refreshUI();
    }

    function refreshUI() {
        createNormalModeButtonArray();
        updateDropdown();
        updateButtonSelectionStates();
    }


    function adjustModeTextPosition(index, modeTextElement, totalModes) {
        if (index === 1) {
            modeTextElement.style.left = '30%';
            modeTextElement.style.transform = 'translateX(0%)';
        } else if (index === totalModes) {
            modeTextElement.style.left = '50%';
            modeTextElement.style.transform = 'translateX(-50%)';
        } else {
            modeTextElement.style.left = '50%';
            modeTextElement.style.transform = 'translateX(-50%)';
        }
    }
}

function checkSampleRunCodeStatus()
{
    gRunCodeInScriptStatus = !gRunCodeInScriptStatus;

    let button = document.getElementById('DirectorNormalMode-codestaus');
    if(gRunCodeInScriptStatus)
    {
        gGetCommandIsEmpty = false;
        button.textContent = window.LanguageManager.getTranslatedText("Stop");
        
        let Profile = document.getElementById('Select_Profile');
        let ProfileIndex    = Number(Profile.value);
        let ConfigFileIndex = Number(gAIDirectorSelectedIndex);

        const allWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
        let currentOrderIds = Array.from(allWrappers).map(wrapper => wrapper.getAttribute('data-id'));
        let orderedSelectedIds = currentOrderIds.filter(id => selectedIds.includes(id));
        let orderedNotSelectedIds = currentOrderIds.filter(id => !selectedIds.includes(id));
        let actionIndex;
        let jsonmsg = {};

        for (const id of orderedSelectedIds) 
        {
            actionIndex = indexMap[currentOrderIds.indexOf(id)];
        }

        if(gLastAIDirectorModeIndex != ConfigFileIndex)
        {
            gLastAIDirectorModeIndex = ConfigFileIndex;
            jsonmsg = {
                Command: "SetSystemSetting",
                System: {
                    AutoConnection: {
                        AIDirectorMode: ConfigFileIndex,
                    }
                }
            };
            AiDirector_sendMessage("SetSystemSetting", jsonmsg);
        }

        // shouldStop = false;
        currentModeIndex = 0;
        
        gOrderedSelectedIds = selectedIds.slice();

        const runModeSelect = document.getElementById('DirectorNormalMode-runmodeSelect');
        const runMode = '0'; 
        
        if(runModeSelect)
        {
            runMode = runModeSelect.value;
        }
     
        if (runMode === "0") 
        {
            if(gProfileData[ProfileIndex][ConfigFileIndex] !== undefined)
            {
                if(!gProfileData[ProfileIndex][ConfigFileIndex].updated)
                {

                }
                else
                {
                    UnblockUIforPage();
                    var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
                    Programming_Workspace.style.display = 'none';
                    const getAllWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
                    let getcurrentOrderIds = Array.from(getAllWrappers).map(wrapper => wrapper.getAttribute('data-id'));
                    let getorderedSelectedIds = getcurrentOrderIds.filter(id => selectedIds.includes(id));
                    let getorderedNotSelectedIds = getcurrentOrderIds.filter(id => !selectedIds.includes(id));
                    
                    for (const id of getorderedNotSelectedIds) 
                    {
                        const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
                        const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
                        otherWrapper.classList.add("fade-color");
                        otherWrapper.classList.remove("active-hover-effect");
                        modeText.classList.remove('show-modeText');
                    }
                
                    for (const id of getorderedSelectedIds) 
                    {
                        const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
                        const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
                        otherWrapper.classList.remove("fade-color");
                        otherWrapper.classList.add("active-hover-effect");
                        modeText.classList.add('show-modeText');
                    }

                    const scriptData = gProfileData[ProfileIndex][ConfigFileIndex].xmlData;
                    
                    initBlockly();
                    profile1XmlString = decryptXmlString(scriptData);
                    updateWorkspaceWithProfileData();
                    runCode();
                    if ($(".Director_Btn").hasClass('inactive')) 
                    {
                        $(".Director_Btn").removeClass('inactive').addClass('active');
                    }
                    setTimeout(() => {
                        gDirectorCheckInterval = setInterval(() => {
                            sendCheckDirectorRunCommand();
                        }, 200);
                    },100);
                }
            }
        }
    }
    else
    {
        button.textContent = window.LanguageManager.getTranslatedText("Run");
        stopCode();
        if ($(".Director_Btn").hasClass('active')) 
        {
            $(".Director_Btn").removeClass('active').addClass('inactive');
        }
        clearInterval(gDirectorCheckInterval);

        SettingUIoptinstatus(false);
        const getAllWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
        let getcurrentOrderIds = Array.from(getAllWrappers).map(wrapper => wrapper.getAttribute('data-id'));
        let getorderedSelectedIds = getcurrentOrderIds.filter(id => selectedIds.includes(id));
        let getorderedNotSelectedIds = getcurrentOrderIds.filter(id => !selectedIds.includes(id));
        getorderedSelectedIds.forEach(otherId => 
        {                
            const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${otherId}"]`);
            const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
            otherWrapper.classList.remove("fade-color");
            otherWrapper.classList.remove("active-hover-effect");
            modeText.classList.remove('show-modeText');
        });
        for (const id of getorderedNotSelectedIds) {
            getorderedNotSelectedIds.forEach(otherId => {
                const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${otherId}"]`);
                const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');                    
                if (otherId !== id) {
                    otherWrapper.classList.remove("fade-color");
                    otherWrapper.classList.remove("active-hover-effect");
                    modeText.classList.remove('show-modeText');
                }
            });  
        }
        let wrapper2 = document.getElementById('DirectorNormalMode-button-wrapper2');
        let wrapper3 = document.getElementById('DirectorNormalMode-button-wrapper3');
        wrapper2.className = 'DirectorNormalMode-button-wrapper fade-color';
        wrapper3.className = 'DirectorNormalMode-button-wrapper fade-color';
    }
}

let gAIDirectorSelectedIndex = -1;
let gNowOpenProfileIndex = 0;

function editScriptWorkspace(){
    var backgroundWindow = document.getElementById('background_AIDirectorEdit_block_Window');
    backgroundWindow.style.display = 'block';

    stopCode();
    if ($(".Director_Btn").hasClass('active')) 
    {
        $(".Director_Btn").removeClass('active').addClass('inactive');
    }
    clearInterval(gDirectorCheckInterval);

    AiDirector_sendMessage("GetCameraListForDirector");
    AiDirector_sendMessage("GetSoundNumbersForDirector");

    let button = document.getElementById('script-run-button');
    if(button.textContent == window.LanguageManager.getTranslatedText("Run"))
    {
        gRunCodeInScriptStatus = false;
    }

    var elementValue;
    if(gAIDirectorSelectedIndex !=-1 )
    {
        elementValue = gAIDirectorSelectedIndex;
    }
    else
    {
        return;
    }

    var Programming_Easymode = document.getElementById('Programming_Easymode_Div');
    if(Programming_Easymode){
        Programming_Easymode.style.display = 'none';
    }
    var Programming_Easymode_message = document.getElementById('Easymode_message_tabs_content');
    if(Programming_Easymode_message){
        Programming_Easymode_message.style.display = 'none';
    }

    var element = document.getElementById('DirectorNormalMode-stoprunlayout');
    if(element)
    {
        element.style.borderBottom = 'none';
    }
 
    gGetProfileNoDisplayWorkspace = false

    gNowOpenProfileIndex = parseInt(elementValue,10);
    var Profile = document.getElementById('Select_Profile');
    let ProfileIndex    = Number(Profile.value);
    let ConfigFileIndex = Number(elementValue);
    console.log('ProfileIndex : ',ProfileIndex,'ConfigFileIndex : ',ConfigFileIndex);

    let jsonmsg = {};
    if(!gProfileData[ProfileIndex][ConfigFileIndex].updated)
    {
        // jsonmsg = {
        //     Command: "GetAIDirectorProfileDataForDirector",
        //     ProfileIndex: ProfileIndex,
        //     ConfigFileIndex: ConfigFileIndex,
        // };
        // AiDirector_sendMessage("GetAIDirectorProfileDataForDirector", jsonmsg);
        // blockUIforPage();
    }
    else
    {
        UnblockUIforPage();
        var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
        Programming_Workspace.style.display = 'none';
    }

    jsonmsg = {
        Command: "SetSystemSetting",
        System: {
            AutoConnection: {
                AIDirectorMode: ConfigFileIndex,
            }
        }
    };
    AiDirector_sendMessage("SetSystemSetting", jsonmsg);
    var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
    Programming_Workspace.style.display = 'block';
    Programming_Workspace.style.display = 'flex';

    const scriptData = gProfileData[ProfileIndex][ConfigFileIndex].xmlData; 
    
    initBlockly();

    profile1XmlString = scriptData;
    profile1XmlString = decryptXmlString(profile1XmlString);

    updateWorkspaceWithProfileData();

    // gProfileResponseReceived = false;
    //startRetryMechanism();
    // blockUIforPage();
    // 檢查元素的原型鏈

    const parent = document.getElementById("category_Layout").parentNode;
    const oldElem = document.getElementById("category_Layout");
    const html = oldElem.outerHTML.replace(/name="Layout"/, `name="${window.LanguageManager.getTranslatedText("Layout")}"`);
    const tempDiv = document.createElement('div');
    tempDiv.innerHTML = html;
    parent.replaceChild(tempDiv.firstChild, oldElem);

}

let gProfileResponseReceived = false;
let gProfileRetryInterval = 1000;
let gProfileRetryTimer;
let gProfileRetryCount = 0;

let gGetProfileTempData = false;
let gProfileTempData = [];
let gProfileUpdatedFlag = [];


function startRetryGetProfile() {
    gProfileRetryTimer = setInterval(function() {
        var Profile = document.getElementById('Select_Profile');
        if (!gProfileResponseReceived) {
            // var jsonmsg = {};
            // jsonmsg.Command   = "GetAIDirectorProfileDataForDirector";
            // jsonmsg.ConfigFileIndex = parseInt(gEditScriptID,10);
            // jsonmsg.ProfileIndex = parseInt(Profile.value,10);
            // setTimeout(function() {
            //     AiDirector_sendMessage("GetAIDirectorProfileDataForDirector",jsonmsg);
            // }, 50);
            gProfileRetryCount++;
        } else {
            clearInterval(gProfileRetryTimer);
        }
        if(gProfileRetryCount >= 1 && !gGetProfileNoDisplayWorkspace)
        {
            var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
            Programming_Workspace.style.display = 'block';
            Programming_Workspace.style.display = 'flex';
            
            gProfileRetryCount = 0; 

            initBlockly();
        }
    }, gProfileRetryInterval);
}

function startRetryMechanism() {
    gProfileRetryTimer = setInterval(function() {
        var Profile = document.getElementById('Select_Profile');
        if (!gProfileResponseReceived) {
            // var jsonmsg = {};
            // jsonmsg.Command   = "GetAIDirectorProfileDataForDirector";
            // jsonmsg.ConfigFileIndex = parseInt(gEditScriptID,10);
            // jsonmsg.ProfileIndex = parseInt(Profile.value,10);
            // setTimeout(function() {
            //     AiDirector_sendMessage("GetAIDirectorProfileDataForDirector",jsonmsg);
            // }, 50);
            gProfileRetryCount++;
        } else {
            clearInterval(gProfileRetryTimer);
        }
        if(gProfileRetryCount >= 1 && !gGetProfileNoDisplayWorkspace)
        {
            var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
            Programming_Workspace.style.display = 'block';
            Programming_Workspace.style.display = 'flex';
            
            gProfileRetryCount = 0; 

            initBlockly();
        }
    }, gProfileRetryInterval);
}

function ProfileWorkspaceClose(){

    Blockly.DropDownDiv.hideWithoutAnimation();
    
    var backgroundWindow = document.getElementById('background_AIDirectorEdit_block_Window');
    backgroundWindow.style.display = 'none';

    gRunCodeInScriptStatus = false;
    stopCode();
    if ($(".Director_Btn").hasClass('active')) 
    {
        $(".Director_Btn").removeClass('active').addClass('inactive');
    }
    clearInterval(gDirectorCheckInterval);

    let sampleModebutton = document.getElementById('DirectorNormalMode-codestaus');
    let editbutton = document.getElementById('DirectorNormalMode-editChanges');
    let button = document.getElementById('script-run-button');
    button.textContent = window.LanguageManager.getTranslatedText("Run");
    sampleModebutton.textContent = window.LanguageManager.getTranslatedText("Run");
    editbutton.disabled = false;

    scriptList = [];
    
    var Programming_Easymode = document.getElementById('Programming_Easymode_Div');
    var Programming_Workspace = document.getElementById('Programming_Workspace_Div');
    var Programming_Easymode_message = document.getElementById('Easymode_message_tabs_content');
    var stoprunlayout = document.getElementById('DirectorNormalMode-stoprunlayout');
    if(stoprunlayout)
    {
        stoprunlayout.style.borderBottom = 'solid 1px rgba(137, 207, 216, 1)';
    }
    if(Programming_Easymode){
        Programming_Easymode.style.display = 'block';
    }
    if(Programming_Easymode_message){
        Programming_Easymode_message.style.display = 'block';
    }
    if(Programming_Workspace){
        Programming_Workspace.style.display = 'none';
    }

    const getAllWrappers = document.querySelectorAll('.DirectorNormalMode-button-wrapper');
    let getcurrentOrderIds = Array.from(getAllWrappers).map(wrapper => wrapper.getAttribute('data-id'));
    let getorderedSelectedIds = getcurrentOrderIds.filter(id => selectedIds.includes(id));
    let getorderedNotSelectedIds = getcurrentOrderIds.filter(id => !selectedIds.includes(id));
    
    for (const id of getorderedNotSelectedIds) 
    {
        const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
        const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
        if(id == 'Presenter' || id == 'Cruise' )
        {
            otherWrapper.classList.add("fade-color");
        }
        else
            otherWrapper.classList.remove("fade-color");
        otherWrapper.classList.remove("active-hover-effect");
        modeText.classList.remove('show-modeText');
    }

    for (const id of getorderedSelectedIds) 
    {
        const otherWrapper = document.querySelector(`.DirectorNormalMode-button-wrapper[data-id="${id}"]`);
        const modeText = otherWrapper.querySelector('.DirectorNormalMode-modeText');
        otherWrapper.classList.remove("fade-color");
        otherWrapper.classList.remove("active-hover-effect");
        modeText.classList.remove('show-modeText');
    }


}

function ProfileWorkspaceSave(){
    var xml = Blockly.Xml.workspaceToDom(workspace);
    var Profile = document.getElementById('Select_Profile');
    var jsonmsg = {};

    if(Profile.length !== 0)
    {
        let workspaceCode = Blockly.JavaScript.workspaceToCode(workspace);
        let workspacejsonmsg = workspaceCode.split(';\n').filter(Boolean).map(JSON.parse);
        let changeJsonmsg = workspacejsonmsg.filter(msg => idActionList.some(item => item.id === msg.id));
        let jsonCommand = {};
        let messageLabel = document.getElementById("profile-save-message");
        let Profile = document.getElementById('Select_Profile');
        let ProfileIndex = parseInt(Profile.value,10);
        let ConfigFileIndex = parseInt(gAIDirectorSelectedIndex,10);


        console.log('ProfileIndex : ',ProfileIndex,'ConfigFileIndex : ',ConfigFileIndex);

        if(messageLabel){
            messageLabel.style.display = "none";
    
            let dots = 0;
            
            gDotsIntervalMessageTimer = setInterval(() => {
                dots = (dots + 1) % 5;
                let dotText = '.'.repeat(dots);
                if(gAIDirectorSelectedIndex <= -1){
                    gAIDirectorSelectedIndex = 0;
                }
                messageLabel.textContent = window.LanguageManager.getTranslatedText("Saving_Profile")+' ' + Profile.value + ' ' + 
                window.LanguageManager.getTranslatedText("mode")+' '+(gAIDirectorSelectedIndex + 1) + ' ' + 
                window.LanguageManager.getTranslatedText("data")+' '+ dotText;
                messageLabel.style.display = "block";
            }, 250);

            setTimeout(function() {
                clearInterval(gDotsIntervalMessageTimer);
                clearInterval(gDotsIntervalMessageTimer);
                clearInterval(gDotsIntervalMessageTimer);
                messageLabel.textContent = window.LanguageManager.getTranslatedText("Profile")+' '+Profile.value + ' '+
                window.LanguageManager.getTranslatedText("mode")+' '+(gNowOpenProfileIndex+1)+ ' '+
                window.LanguageManager.getTranslatedText("Save_Success");

                messageLabel.style.display = "none";
            }, 1000);
        }

        jsonCommand.Command         = "SetAIDirectorAutoProfileDataForDirector";
        jsonCommand.ScriptData      = JSON.stringify(changeJsonmsg);
        jsonCommand.ProfileIndex    = ProfileIndex;
        jsonCommand.ConfigFileIndex = ConfigFileIndex,
        AiDirector_sendMessage(jsonCommand.Command,jsonCommand);

        profile1XmlString = Blockly.Xml.domToText(xml);
        jsonmsg.Command         = "SetAIDirectorProfileDataForDirector";
        jsonmsg.AIDirectorXML   = encryptXmlString(profile1XmlString);
        jsonmsg.ProfileIndex    = ProfileIndex;
        jsonmsg.ConfigFileIndex = ConfigFileIndex,
        AiDirector_sendMessage("SetAIDirectorProfileDataForDirector",jsonmsg);
        
        gNowWaitResponseSetProfile = {
            ProfileIndex:ProfileIndex,
            ConfigFileIndex:ConfigFileIndex
        };

        gProfileData[ProfileIndex][ConfigFileIndex] = {
            xmlData: encryptXmlString(profile1XmlString),
            updated: true
        };
    }
    else
    {
        sendMessageIndex("GetAllProfile"); 
        sendMessageIndex("GetCurrentProfileID");
        let Programming_Workspace = document.getElementById('Programming_Workspace_Div');
        Programming_Workspace.style.display = 'none';
    }
}

function updateProfileSaveMessage(state){
    //console.log('updateProfileSaveMessage !!!!!');
    if(state){
        clearInterval(gDotsIntervalMessageTimer);
        clearInterval(gDotsIntervalMessageTimer);
        clearInterval(gDotsIntervalMessageTimer);

        let messageLabel = document.getElementById("profile-save-message");
        let Profile = document.getElementById('Select_Profile');

        if(messageLabel){
            messageLabel.textContent = window.LanguageManager.getTranslatedText("Profile")+' '+Profile.value + ' '+
            window.LanguageManager.getTranslatedText("mode")+' '+(gNowOpenProfileIndex+1)+ ' '+
            window.LanguageManager.getTranslatedText("Save_Success");

            messageLabel.style.display = "block";
            setTimeout(function() {
                messageLabel.style.display = "none";
            }, 1500);
        }
    }
}

function AIDirectormicsendPanTiltCmd(dir) {

    var ptzcmd;
    var jsonmsg = {};
    var cameraIP = GetPreviewCamera; 
    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    } else if(dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    } else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    // sendMessage(ptzcmd,jsonmsg);
    AiDirector_websocket.send(JSON.stringify(jsonmsg));
}

function AIDirectormicpresetTextAction(strSet) {
    var strVal = $("#AIDirectorpresetInput_"+gDeviceIndex).val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            if (strVal == "0") {
                strVal = strSet;
            } else {
                strVal = strVal.concat(strSet);
            }
            break;
        case 2:
            if (strSet < "6") {
                if (strVal <= "25") {
                    strVal = strVal.concat(strSet);
                }
                //else do nothing
            } else {
                if (strVal <= "24") {
                    strVal = strVal.concat(strSet);
                }
            }
            break;
        case 3:
            //do nothing
            break;
        case 4:
            strVal = "";
            break;
    }
    $("#AIDirectorpresetInput_"+gDeviceIndex).val(strVal);
}

function showExecutionLog(button) 
{
    gExecutionLogIsChecked = !gExecutionLogIsChecked;  // Toggle the state
    var EasymodeMessage =  document.getElementById('Easymode_message_Div');
    var EasymodeclearMessage =  document.getElementById('Easymode-clear-message-button');
    
    if(gExecutionLogIsChecked) 
    {
        button.className = 'execution-button-on';
        EasymodeMessage.style.display = 'block';
        EasymodeclearMessage.style.display = 'block';
    } 
    else 
    {
        button.className = 'execution-button-off';
        EasymodeMessage.style.display = 'none';
        EasymodeclearMessage.style.display = 'none';
    }
}

function showScriptExecutionLog(button) 
{
    gScriptLogIsChecked = !gScriptLogIsChecked;  // Toggle the state
    var EasymodeMessage =  document.getElementById('Workspace_message_Div');
    var ButtonMessage =  document.getElementById('workspace_message_button_container');
    
    if(gScriptLogIsChecked) 
    {
        button.className = 'script-execution-button-on';
        EasymodeMessage.style.display      = 'block';
        ButtonMessage.style.display        = 'block';
    } 
    else 
    {
        button.className = 'script-execution-button-off';
        EasymodeMessage.style.display      = 'none';
        ButtonMessage.style.display        = 'none';
    }
}

function checkRunCodeStatus()
{
    gRunCodeInScriptStatus=!gRunCodeInScriptStatus;
    let button = document.getElementById('script-run-button');

    if(gRunCodeInScriptStatus)
    {
        gGetCommandIsEmpty = false;
        button.textContent = window.LanguageManager.getTranslatedText("Stop");
        runCode();
        if ($(".Director_Btn").hasClass('inactive')) 
        {
            $(".Director_Btn").removeClass('inactive').addClass('active');
        }
        setTimeout(() => {
            gDirectorCheckInterval = setInterval(() => {
                sendCheckDirectorRunCommand();
            }, 200);
        },100);
    }
    else
    {
        button.textContent = window.LanguageManager.getTranslatedText("Run");
        stopCode();
        if ($(".Director_Btn").hasClass('active')) 
        {
            $(".Director_Btn").removeClass('active').addClass('inactive');
        }
        clearInterval(gDirectorCheckInterval);
    }
}

function updatedGetCurrentProfile(msg)
{
    let Programming_Workspace = document.getElementById('Programming_Workspace_Div');
    Programming_Workspace.style.display = 'none';

}


var gDirectorLastVoiceTrackingStatus = false;
var gEnableDirectorStatus = false;
function SettingEnableDirectorModeChange(e) 
{
    const isChecked = e.checked;
    gEnableDirectorStatus = isChecked;
    const displayStyle = isChecked ? 'none' : 'block';
    if(document.getElementById("SetEnableDirectorCheckboxInput"))
        document.getElementById("SetEnableDirectorCheckboxInput").checked = isChecked;
    if(document.getElementById("btnEnableDirectorContainer"))
        document.getElementById("btnEnableDirectorContainer").style.display = displayStyle;
    
    modeTexts.forEach((modeDescription, index) => {
        const containerId = "DirectorNormalMode-button" + (index + 1);
        const element = document.getElementById(containerId);
        if (element) {
            if(!e.checked)
                element.classList.add("disabled-color");
            else
                element.classList.remove("disabled-color");
        }
    });
    
    if(document.getElementById("DirectorNormalMode-codestaus"))
        document.getElementById("DirectorNormalMode-codestaus").disabled = !e.checked;
    if(document.getElementById("DirectorNormalMode-editChanges"))
        document.getElementById("DirectorNormalMode-editChanges").disabled = !e.checked;
    if(document.getElementById("Easymode_execution_msg_btn"))
        document.getElementById("Easymode_execution_msg_btn").disabled = !e.checked;
    
    if(!e.checked)
    {

        let DirectorBtn = document.getElementById("DirectorBtn");
        let director_block = document.getElementById("director_block");
        director_block.style.display = "block";
        if(DirectorBtn)
            DirectorBtn.style.display = "none";

        if(gDirectorLastVoiceTrackingStatus)
        {
            gDirectorLastVoiceTrackingStatus = false;
            gVoiceTrackingStatus = true;
            sendMessage("SetVoiceTracking", true);
        }
    }
    else
    {
        let DirectorBtn = document.getElementById("DirectorBtn");
        let director_block = document.getElementById("director_block");
        director_block.style.display = "none";
        if(DirectorBtn)
            DirectorBtn.style.display = "block";

        if(gVoiceTrackingStatus)
        {
            gDirectorLastVoiceTrackingStatus = true;
        }
        else
        {
            gDirectorLastVoiceTrackingStatus = false;
        }

        gVoiceTrackingStatus = false;
        sendMessage("SetVoiceTracking", false);
    }

    let jsonmsg = {
        Command: "SetSystemSetting",
        System: {
            EnableAIDirector: {
                EnableAIDirector: isChecked,
            }
        }
    };

    AiDirector_sendMessage("SetSystemSetting", jsonmsg);

}